/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.expression.AssignExpression;
import com.google.summit.ast.expression.LiteralExpression;
import com.google.summit.ast.expression.VariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewKeyValueObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;

public final class ASTLiteralExpression
extends AbstractApexNode.Single<LiteralExpression> {
    ASTLiteralExpression(LiteralExpression literalExpression) {
        super(literalExpression);
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public LiteralType getLiteralType() {
        if (this.node instanceof LiteralExpression.StringVal) {
            return LiteralType.STRING;
        }
        if (this.node instanceof LiteralExpression.BooleanVal) {
            return ((LiteralExpression.BooleanVal)this.node).getValue() ? LiteralType.TRUE : LiteralType.FALSE;
        }
        if (this.node instanceof LiteralExpression.IntegerVal) {
            return LiteralType.INTEGER;
        }
        if (this.node instanceof LiteralExpression.DoubleVal) {
            return LiteralType.DOUBLE;
        }
        if (this.node instanceof LiteralExpression.LongVal) {
            return LiteralType.LONG;
        }
        if (this.node instanceof LiteralExpression.DecimalVal) {
            return LiteralType.DECIMAL;
        }
        if (this.node instanceof LiteralExpression.NullVal) {
            return LiteralType.NULL;
        }
        return null;
    }

    public boolean isString() {
        return this.getLiteralType() == LiteralType.STRING;
    }

    public boolean isBoolean() {
        return this.getLiteralType() == LiteralType.TRUE || this.getLiteralType() == LiteralType.FALSE;
    }

    public boolean isInteger() {
        return this.getLiteralType() == LiteralType.INTEGER;
    }

    public boolean isDouble() {
        return this.getLiteralType() == LiteralType.DOUBLE;
    }

    public boolean isLong() {
        return this.getLiteralType() == LiteralType.LONG;
    }

    public boolean isDecimal() {
        return this.getLiteralType() == LiteralType.DECIMAL;
    }

    public boolean isNull() {
        return this.getLiteralType() == LiteralType.NULL;
    }

    public String getImage() {
        return ASTLiteralExpression.literalToString((LiteralExpression)this.node);
    }

    public String getName() {
        if (this.getParent() instanceof ASTAssignmentExpression && ((ApexNode)this.getParent()).getParent() instanceof ASTNewKeyValueObjectExpression) {
            ASTAssignmentExpression parent = (ASTAssignmentExpression)this.getParent();
            VariableExpression target = (VariableExpression)((AssignExpression)parent.node).getTarget();
            return target.getId().getString();
        }
        return null;
    }

    public static enum LiteralType {
        STRING,
        INTEGER,
        LONG,
        DOUBLE,
        DECIMAL,
        TRUE,
        FALSE,
        NULL;

    }
}

