/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.Identifier;
import com.google.summit.ast.expression.CallExpression;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;

public final class ASTMethodCallExpression
extends AbstractApexNode.Single<CallExpression> {
    private final List<Identifier> receiverComponents;

    ASTMethodCallExpression(CallExpression callExpression, List<Identifier> receiverComponents) {
        super(callExpression);
        this.receiverComponents = receiverComponents;
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public String getMethodName() {
        return ((CallExpression)this.node).getId().getString();
    }

    public String getFullMethodName() {
        return this.receiverComponents.stream().map(id -> id.getString() + ".").collect(Collectors.joining()) + this.getMethodName();
    }

    public int getInputParametersSize() {
        return ((CallExpression)this.node).getArgs().size();
    }
}

