/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AvoidBooleanMethodParametersRule
extends AbstractApexRule {
    private static final String BOOLEAN_TYPE = "boolean";

    @Override
    public Object visit(ASTMethod theMethod, Object data) {
        if (!this.isPublicOrGlobal(theMethod)) {
            return data;
        }
        theMethod.descendants(ASTParameter.class).filter(parameter -> this.isBoolean((ASTParameter)parameter)).forEach(parameter -> this.asCtx(data).addViolation((Node)parameter));
        return data;
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTMethod.class, (Class[])new Class[0]);
    }

    private boolean isPublicOrGlobal(ASTMethod method) {
        ASTModifierNode modifier = method.getModifiers();
        return modifier.isPublic() || modifier.isGlobal();
    }

    private boolean isBoolean(ASTParameter parameter) {
        return BOOLEAN_TYPE.equalsIgnoreCase(parameter.getType());
    }
}

