/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.internal.AbstractCounterCheckRule;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;

public class ExcessiveParameterListRule
extends AbstractCounterCheckRule<ASTMethod> {
    public ExcessiveParameterListRule() {
        super(ASTMethod.class);
    }

    @Override
    protected int defaultReportLevel() {
        return 4;
    }

    @Override
    protected FileLocation getReportLocation(ASTMethod node) {
        ApexNode lastParameter = (ApexNode)node.children(ASTParameter.class).last();
        if (lastParameter == null) {
            lastParameter = node;
        }
        TextRange2d textRange = TextRange2d.range2d((int)node.getBeginLine(), (int)node.getBeginColumn(), (int)lastParameter.getEndLine(), (int)lastParameter.getEndColumn());
        return FileLocation.range((FileId)node.getAstInfo().getTextDocument().getFileId(), (TextRange2d)textRange);
    }

    @Override
    protected int getMetric(ASTMethod node) {
        return node.getArity();
    }
}

