/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;

public class ApexCSRFRule
extends AbstractApexRule {
    public static final String INIT = "init";

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!Helper.isTestMethodOrClass(node)) {
            this.checkForCSRF(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTBlockStatement node, Object data) {
        if (node.getParent() instanceof ASTUserClass && Helper.foundAnyDML(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    private void checkForCSRF(ASTMethod node, Object data) {
        if (node.isConstructor() && Helper.foundAnyDML(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        String name = node.getImage();
        if ((node.isStaticInitializer() || this.isInitializerMethod(name)) && Helper.foundAnyDML(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
    }

    private boolean isInitializerMethod(String name) {
        return INIT.equalsIgnoreCase(name);
    }
}

