/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class InaccessibleAuraEnabledGetterRule
extends AbstractApexRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTProperty.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTProperty node, Object data) {
        ASTModifierNode propModifiers = node.getModifiers();
        if (this.hasAuraEnabledAnnotation(propModifiers)) {
            for (ASTMethod method : node.children(ASTMethod.class)) {
                ASTModifierNode methodModifiers;
                if ("void".equals(method.getReturnType()) || !this.isPrivate(methodModifiers = method.getModifiers()) && !this.isProtected(methodModifiers)) continue;
                this.asCtx(data).addViolation((Node)node);
            }
        }
        return data;
    }

    private boolean isPrivate(ASTModifierNode modifierNode) {
        return modifierNode != null && modifierNode.isPrivate();
    }

    private boolean isProtected(ASTModifierNode modifierNode) {
        return modifierNode != null && modifierNode.isProtected();
    }

    private boolean hasAuraEnabledAnnotation(ASTModifierNode modifierNode) {
        for (ASTAnnotation annotation : modifierNode.children(ASTAnnotation.class)) {
            if (!"AuraEnabled".equalsIgnoreCase(annotation.getName())) continue;
            return true;
        }
        return false;
    }
}

