/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlDeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlInsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlMergeStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUndeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpdateStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoslExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApexSharingViolationsRule
extends AbstractApexRule {
    private Map<ApexNode<?>, Object> localCacheOfReportedNodes = new WeakHashMap();

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTDmlDeleteStatement.class, (Class[])new Class[]{ASTDmlInsertStatement.class, ASTDmlMergeStatement.class, ASTDmlUndeleteStatement.class, ASTDmlUpdateStatement.class, ASTDmlUpsertStatement.class, ASTMethodCallExpression.class, ASTSoqlExpression.class, ASTSoslExpression.class});
    }

    public void start(RuleContext ctx) {
        super.start(ctx);
        this.localCacheOfReportedNodes.clear();
    }

    @Override
    public Object visit(ASTSoqlExpression node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTSoslExpression node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDmlUpsertStatement node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDmlUpdateStatement node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDmlUndeleteStatement node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDmlMergeStatement node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDmlInsertStatement node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDmlDeleteStatement node, Object data) {
        this.checkForViolation(node, data);
        return data;
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        if (Helper.isAnyDatabaseMethodCall(node)) {
            this.checkForViolation(node, data);
        }
        return data;
    }

    private void checkForViolation(ApexNode<?> node, Object data) {
        ASTUserClass outerClass;
        ASTUserClass testAnnotationClass;
        ASTUserClass sharingDeclarationClass = (ASTUserClass)node.ancestors(ASTUserClass.class).first();
        if (!(sharingDeclarationClass == null || Helper.isTestMethodOrClass(testAnnotationClass = Optional.ofNullable(outerClass = (ASTUserClass)sharingDeclarationClass.ancestors(ASTUserClass.class).first()).orElse(sharingDeclarationClass)) || Helper.isSystemLevelClass(sharingDeclarationClass) || this.isSharingPresent(sharingDeclarationClass))) {
            this.reportViolation(sharingDeclarationClass, data);
        }
    }

    private void reportViolation(ApexNode<?> node, Object data) {
        ASTModifierNode modifier = (ASTModifierNode)node.firstChild(ASTModifierNode.class);
        if (modifier != null) {
            if (this.localCacheOfReportedNodes.put(modifier, data) == null) {
                this.asCtx(data).addViolation((Node)modifier);
            }
        } else if (this.localCacheOfReportedNodes.put(node, data) == null) {
            this.asCtx(data).addViolation(node);
        }
    }

    private boolean isSharingPresent(ASTUserClass node) {
        return node.getModifiers().isWithoutSharing() || node.getModifiers().isWithSharing() || node.getModifiers().isInheritedSharing();
    }
}

