/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.Identifier;
import com.google.summit.ast.Node;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.TypeRef;
import com.google.summit.ast.declaration.EnumDeclaration;
import com.google.summit.ast.expression.Expression;
import com.google.summit.ast.expression.LiteralExpression;
import java.util.Arrays;
import java.util.Optional;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;

public final class ASTField
extends AbstractApexNode.Many<Node> {
    private final Identifier name;
    private final Optional<Expression> value;
    private final String typeName;

    ASTField(TypeRef typeRef, Identifier name, Optional<Expression> value) {
        super(value.isPresent() ? Arrays.asList(typeRef, name, (Node)value.get()) : Arrays.asList(typeRef, name));
        this.name = name;
        this.value = value;
        this.typeName = ASTField.caseNormalizedTypeIfPrimitive(typeRef.asCodeString());
    }

    ASTField(EnumDeclaration enumType, Identifier name) {
        super(Arrays.asList(enumType, name));
        this.name = name;
        this.value = Optional.empty();
        this.typeName = enumType.getId().asCodeString();
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public String getImage() {
        return this.getName();
    }

    public String getType() {
        return this.typeName;
    }

    public ASTModifierNode getModifiers() {
        return (ASTModifierNode)this.firstChild(ASTModifierNode.class);
    }

    public String getName() {
        return this.name.getString();
    }

    public String getValue() {
        if (this.value.isPresent() && this.value.get() instanceof LiteralExpression) {
            return ASTField.literalToString((LiteralExpression)this.value.get());
        }
        return null;
    }

    @Override
    public boolean hasRealLoc() {
        if (!(this.nodes.get(0) instanceof TypeRef)) {
            return super.hasRealLoc();
        }
        TypeRef typeRef = (TypeRef)this.nodes.get(0);
        boolean allHaveRealLoc = typeRef.getComponents().stream().noneMatch(c -> c.getId().getSourceLocation().isUnknown());
        for (int i = 1; i < this.nodes.size(); ++i) {
            allHaveRealLoc &= !((Node)this.nodes.get(i)).getSourceLocation().isUnknown();
        }
        return allHaveRealLoc;
    }

    @Override
    protected void calculateTextRegion(TextDocument sourceCode) {
        SourceLocation loc;
        if (this.nodes.get(0) instanceof TypeRef) {
            super.calculateTextRegion(sourceCode);
        }
        if ((loc = this.name.getSourceLocation()).isUnknown()) {
            return;
        }
        this.setRegion(TextRegion.fromBothOffsets((int)sourceCode.offsetAtLineColumn(TextPos2d.pos2d((int)loc.getStartLine(), (int)(loc.getStartColumn() + 1))), (int)sourceCode.offsetAtLineColumn(TextPos2d.pos2d((int)loc.getEndLine(), (int)(loc.getEndColumn() + 1)))));
    }
}

