/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.expression.BinaryExpression;

public enum BinaryOperator {
    ADDITION("+"),
    SUBTRACTION("-"),
    MULTIPLICATION("*"),
    DIVISION("/"),
    LEFT_SHIFT("<<"),
    RIGHT_SHIFT_SIGNED(">>"),
    RIGHT_SHIFT_UNSIGNED(">>>"),
    BITWISE_AND("&"),
    BITWISE_OR("|"),
    BITWISE_XOR("^"),
    NULL_COALESCING("??");

    private final String symbol;

    private BinaryOperator(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static BinaryOperator valueOf(BinaryExpression.Operator op) {
        switch (op) {
            case ADDITION: {
                return ADDITION;
            }
            case SUBTRACTION: {
                return SUBTRACTION;
            }
            case MULTIPLICATION: {
                return MULTIPLICATION;
            }
            case DIVISION: {
                return DIVISION;
            }
            case LEFT_SHIFT: {
                return LEFT_SHIFT;
            }
            case RIGHT_SHIFT_SIGNED: {
                return RIGHT_SHIFT_SIGNED;
            }
            case RIGHT_SHIFT_UNSIGNED: {
                return RIGHT_SHIFT_UNSIGNED;
            }
            case BITWISE_AND: {
                return BITWISE_AND;
            }
            case BITWISE_OR: {
                return BITWISE_OR;
            }
            case BITWISE_XOR: {
                return BITWISE_XOR;
            }
            case NULL_COALESCING: {
                return NULL_COALESCING;
            }
        }
        throw new IllegalArgumentException("Invalid binary operator " + op);
    }
}

