/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApexSuggestUsingNamedCredRule
extends AbstractApexRule {
    private static final String SET_HEADER = "setHeader";
    private static final String AUTHORIZATION = "Authorization";
    private final Set<String> listOfAuthorizationVariables = new HashSet<String>();

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node)) {
            return data;
        }
        for (ASTVariableDeclaration varDecl : node.descendants(ASTVariableDeclaration.class)) {
            this.findAuthLiterals(varDecl);
        }
        for (ASTField fDecl : node.descendants(ASTField.class)) {
            this.findFieldLiterals(fDecl);
        }
        for (ASTMethodCallExpression method : node.descendants(ASTMethodCallExpression.class)) {
            this.flagAuthorizationHeaders(method, data);
        }
        this.listOfAuthorizationVariables.clear();
        return data;
    }

    private void findFieldLiterals(ASTField fDecl) {
        if ("String".equals(fDecl.getType()) && AUTHORIZATION.equalsIgnoreCase(fDecl.getValue())) {
            this.listOfAuthorizationVariables.add(Helper.getFQVariableName(fDecl));
        }
    }

    private void flagAuthorizationHeaders(ASTMethodCallExpression node, Object data) {
        if (!Helper.isMethodName(node, SET_HEADER)) {
            return;
        }
        ASTBinaryExpression binaryNode = (ASTBinaryExpression)node.firstChild(ASTBinaryExpression.class);
        if (binaryNode != null) {
            this.runChecks(binaryNode, data);
        }
        this.runChecks(node, data);
    }

    private void findAuthLiterals(ApexNode<?> node) {
        ASTVariableExpression variable;
        ASTLiteralExpression literal = (ASTLiteralExpression)node.firstChild(ASTLiteralExpression.class);
        if (literal != null && (variable = (ASTVariableExpression)node.firstChild(ASTVariableExpression.class)) != null && this.isAuthorizationLiteral(literal)) {
            this.listOfAuthorizationVariables.add(Helper.getFQVariableName(variable));
        }
    }

    private void runChecks(ApexNode<?> node, Object data) {
        ASTVariableExpression varNode;
        ASTLiteralExpression literalNode = (ASTLiteralExpression)node.firstChild(ASTLiteralExpression.class);
        if (literalNode != null && this.isAuthorizationLiteral(literalNode)) {
            this.asCtx(data).addViolation((Node)literalNode);
        }
        if ((varNode = (ASTVariableExpression)node.firstChild(ASTVariableExpression.class)) != null && this.listOfAuthorizationVariables.contains(Helper.getFQVariableName(varNode))) {
            this.asCtx(data).addViolation((Node)varNode);
        }
    }

    private boolean isAuthorizationLiteral(ASTLiteralExpression literal) {
        String lit;
        return literal.isString() && AUTHORIZATION.equalsIgnoreCase(lit = literal.getImage());
    }
}

