/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.common.collect.ImmutableSortedSet;
import com.google.summit.ast.modifier.AnnotationModifier;
import java.util.Comparator;
import java.util.NavigableSet;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;

public final class ASTAnnotation
extends AbstractApexNode.Single<AnnotationModifier> {
    private static final NavigableSet<String> NORMALIZED_ANNOTATION_NAMES = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object[])new String[]{"AllowCertifiedApex", "AuraEnabled", "Deprecated", "Future", "HiddenFromDoc", "HttpDelete", "HttpGet", "HttpPatch", "HttpPost", "HttpPut", "InvocableMethod", "InvocableVariable", "IsTest", "JsonAccess", "NamespaceAccessible", "NamespaceGuard", "PermGuard", "PrivateApi", "ReadOnly", "RemoteAction", "RestResource", "SfdcOnly", "SuppressWarnings", "TestSetup", "TestVisible", "UseConnectDeserializer", "UseConnectSerializer", "VisibleApiVersion"}).build();

    ASTAnnotation(AnnotationModifier annotationModifier) {
        super(annotationModifier);
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public String getName() {
        String rawName = this.getRawName();
        if (NORMALIZED_ANNOTATION_NAMES.contains(rawName)) {
            return NORMALIZED_ANNOTATION_NAMES.floor(rawName);
        }
        return rawName;
    }

    public String getRawName() {
        return ((AnnotationModifier)this.node).getName().getString();
    }

    public String getImage() {
        return this.getName();
    }

    public boolean isResolved() {
        return NORMALIZED_ANNOTATION_NAMES.contains(this.getRawName());
    }
}

