/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex;

import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotationParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

final class ApexViolationSuppressors {
    private static final ViolationSuppressor APEX_ANNOT_SUPPRESSOR = new ViolationSuppressor(){

        public String getId() {
            return "@SuppressWarnings";
        }

        public Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            if (node instanceof ApexNode && ApexViolationSuppressors.isSuppressed((ApexNode)node, rv.getRule())) {
                return new Report.SuppressedViolation(rv, (ViolationSuppressor)this, null);
            }
            return null;
        }
    };
    static final List<ViolationSuppressor> ALL_APEX_SUPPRESSORS = CollectionUtil.listOf((Object)APEX_ANNOT_SUPPRESSOR, (Object[])new ViolationSuppressor[0]);

    private ApexViolationSuppressors() {
    }

    private static boolean isSuppressed(ApexNode<?> node, Rule rule) {
        boolean result = ApexViolationSuppressors.suppresses(node, rule);
        if (!result) {
            for (ApexNode parent = (ApexNode)node.getParent(); !result && parent != null; parent = (ApexNode)parent.getParent()) {
                result = ApexViolationSuppressors.suppresses(parent, rule);
            }
        }
        return result;
    }

    private static boolean canSuppressWarnings(ApexNode<?> node) {
        return node instanceof ASTFieldDeclarationStatements || node instanceof ASTVariableDeclarationStatements || node instanceof ASTField || node instanceof ASTMethod || node instanceof ASTUserClassOrInterface || node instanceof ASTUserEnum || node instanceof ASTParameter;
    }

    private static boolean suppresses(ApexNode<?> node, Rule rule) {
        return ApexViolationSuppressors.canSuppressWarnings(node) && ApexViolationSuppressors.hasSuppressWarningsAnnotationFor(node, rule);
    }

    private static boolean hasSuppressWarningsAnnotationFor(ApexNode<?> node, Rule rule) {
        return node.children(ASTModifierNode.class).children(ASTAnnotation.class).any(a -> ApexViolationSuppressors.suppresses(a, rule));
    }

    private static boolean suppresses(ASTAnnotation annot, Rule rule) {
        String ruleAnno = "PMD." + rule.getName();
        if ("SuppressWarnings".equalsIgnoreCase(annot.getName())) {
            for (ASTAnnotationParameter param : annot.children(ASTAnnotationParameter.class)) {
                String image = param.getValue();
                if (image == null) continue;
                TreeSet<String> paramValues = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                paramValues.addAll(Arrays.asList(image.replaceAll("\\s+", "").split(",")));
                if (!paramValues.contains("PMD") && !paramValues.contains(ruleAnno) && !paramValues.contains("all")) continue;
                return true;
            }
        }
        return false;
    }
}

