/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.buildtools.surefire;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoConsoleReportEventListener;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

class AccumulatingConsoleReporter
extends StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> {
    private final boolean showSuccessfulTests;
    private final boolean showFailedTests;
    private final boolean showSkippedTests;
    private final Deque<ReportEntry> testSets = new ArrayDeque<ReportEntry>();
    private TestSetStats rootTestSetStats;
    private int rootTestSetElapsedTimeMillis;
    private final Map<String, Deque<String>> nestedTestSetNames = new HashMap<String, Deque<String>>();
    private final Map<String, TestSetStats> accumulatedTestSetStats = new HashMap<String, TestSetStats>();
    private final Map<String, Integer> totalElapsedTimeMillis = new HashMap<String, Integer>();
    private final Map<String, List<String>> accumulatedTestResults = new HashMap<String, List<String>>();

    public AccumulatingConsoleReporter(ConsoleLogger logger, boolean showSuccessfulTests, boolean showFailedTests, boolean showSkippedTests) {
        super(logger);
        this.showSuccessfulTests = showSuccessfulTests;
        this.showFailedTests = showFailedTests;
        this.showSkippedTests = showSkippedTests;
    }

    public void testSetStarting(TestSetReportEntry report) {
        Deque<String> nesting;
        if (this.testSets.isEmpty()) {
            this.rootTestSetStats = new TestSetStats(true, true);
            this.rootTestSetElapsedTimeMillis = 0;
        }
        this.testSets.addLast((ReportEntry)report);
        boolean isNested = this.testSets.size() > 1;
        String prefix = isNested ? "    " : "";
        String outerTestClass = AccumulatingConsoleReporter.getOuterTestClass(report);
        if (!this.nestedTestSetNames.containsKey(outerTestClass)) {
            this.nestedTestSetNames.put(outerTestClass, new LinkedList());
        }
        if ((nesting = this.nestedTestSetNames.get(outerTestClass)).isEmpty()) {
            nesting.addLast(outerTestClass);
            this.accumulatedTestSetStats.put(outerTestClass, new TestSetStats(true, true));
            this.totalElapsedTimeMillis.put(outerTestClass, 0);
            this.accumulatedTestResults.put(outerTestClass, new LinkedList());
            MessageBuilder buffer = MessageUtils.buffer();
            this.getConsoleLogger().info(prefix + "Running " + buffer.strong((Object)outerTestClass));
        } else {
            String fullName = report.getSourceText();
            if (fullName == null) {
                fullName = report.getSourceName();
            }
            fullName = fullName.replaceAll("\\$", " ");
            nesting.addLast(fullName);
        }
    }

    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        String indentation;
        String outerTestClass = AccumulatingConsoleReporter.getOuterTestClass((TestSetReportEntry)report);
        Deque<String> nesting = this.nestedTestSetNames.get(outerTestClass);
        int elapsedMillis = this.totalElapsedTimeMillis.get(outerTestClass) + report.getElapsed();
        this.totalElapsedTimeMillis.put(outerTestClass, elapsedMillis);
        TestSetStats accumulated = this.accumulatedTestSetStats.get(outerTestClass);
        AccumulatingConsoleReporter.accumulateTestSetStats(accumulated, testSetStats.getReportEntries());
        boolean isNested = this.testSets.size() > 1;
        String string = indentation = isNested ? "    " : "";
        if (isNested) {
            AccumulatingConsoleReporter.accumulateTestSetStats(this.rootTestSetStats, testSetStats.getReportEntries());
            this.rootTestSetElapsedTimeMillis += report.getElapsed().intValue();
        } else {
            accumulated = this.rootTestSetStats;
            AccumulatingConsoleReporter.accumulateTestSetStats(accumulated, testSetStats.getReportEntries());
            elapsedMillis = this.rootTestSetElapsedTimeMillis + report.getElapsed();
        }
        this.testSets.removeLast();
        this.accumulatedTestResults.get(outerTestClass).addAll(testResults);
        String prefix = "\u2514\u2500 ";
        if (((testSetStats.getErrors() > 0 || testSetStats.getFailures() > 0) && this.showFailedTests || testSetStats.getSkipped() > 0 && this.showSkippedTests || testSetStats.getCompletedCount() > 0 && this.showSuccessfulTests) && !testSetStats.getReportEntries().isEmpty() && nesting.size() > 1) {
            String previousTestSetName = null;
            for (String fullTestSetName : nesting) {
                if (previousTestSetName != null) {
                    prefix = "    " + prefix;
                    String shortenedTestSetName = fullTestSetName;
                    if (fullTestSetName.startsWith(previousTestSetName)) {
                        shortenedTestSetName = fullTestSetName.substring(previousTestSetName.length());
                    }
                    this.getConsoleLogger().info(prefix + shortenedTestSetName);
                }
                previousTestSetName = fullTestSetName + " ";
            }
        }
        if (nesting.size() == 1) {
            prefix = indentation + prefix;
        }
        String testSetName = AccumulatingConsoleReporter.getTestSetName(report);
        for (WrappedReportEntry entry : testSetStats.getReportEntries()) {
            String shortTestCaseName = AccumulatingConsoleReporter.getTestCaseName(entry, testSetName);
            MessageBuilder buffer = MessageUtils.buffer();
            if (entry.isErrorOrFailure() && this.showFailedTests) {
                buffer.failure((Object)"\u2718 ").failure((Object)shortTestCaseName);
                this.getConsoleLogger().info("    " + prefix + buffer);
                continue;
            }
            if (entry.isSkipped() && this.showSkippedTests) {
                buffer.warning((Object)"\u21b7 ").warning((Object)shortTestCaseName);
                this.getConsoleLogger().info("    " + prefix + buffer);
                continue;
            }
            if (!this.showSuccessfulTests) continue;
            buffer.success((Object)"\u2714 ").a((CharSequence)shortTestCaseName);
            this.getConsoleLogger().info("    " + prefix + buffer);
        }
        if (nesting.size() == 1) {
            if (accumulated.getCompletedCount() == 0) {
                this.accumulatedTestResults.get(outerTestClass).add("No tests were executed! Test class: " + outerTestClass);
            }
            WrappedReportEntry reportWithTotalElapsedMillis = new WrappedReportEntry((ReportEntry)report, report.getReportEntryType(), Integer.valueOf(elapsedMillis), null, null);
            this.getConsoleLogger().info(indentation + accumulated.getColoredTestSetSummary(reportWithTotalElapsedMillis, false));
            this.printTestResults(accumulated, this.accumulatedTestResults.get(outerTestClass));
            this.accumulatedTestSetStats.remove(outerTestClass);
            this.nestedTestSetNames.remove(outerTestClass);
            this.totalElapsedTimeMillis.remove(outerTestClass);
            this.accumulatedTestResults.remove(outerTestClass);
        } else {
            nesting.pollLast();
        }
    }

    private void printTestResults(TestSetStats accumulated, List<String> testResults) {
        if (accumulated.getErrors() > 0 || accumulated.getFailures() > 0 || accumulated.getCompletedCount() == 0) {
            for (String line : testResults) {
                this.getConsoleLogger().error(line);
            }
        } else if (accumulated.getSkipped() > 0) {
            for (String line : testResults) {
                this.getConsoleLogger().warning(line);
            }
        } else {
            for (String line : testResults) {
                this.getConsoleLogger().info(line);
            }
        }
    }

    private static String getTestSetName(WrappedReportEntry report) {
        String testSetName = report.getSourceText();
        if (testSetName == null) {
            testSetName = report.getSourceName();
        }
        return testSetName;
    }

    private static String getTestCaseName(WrappedReportEntry entry, String testSetName) {
        String testCaseName = entry.getNameText();
        if (testCaseName == null) {
            testCaseName = entry.getName();
        }
        if (testCaseName == null) {
            testCaseName = AccumulatingConsoleReporter.getTestSetName(entry);
        }
        String shortenedTestCaseName = testCaseName;
        if (testCaseName.startsWith(testSetName)) {
            shortenedTestCaseName = testCaseName.substring(testSetName.length());
        }
        if (shortenedTestCaseName.isEmpty()) {
            shortenedTestCaseName = "[unnamed test case]";
        }
        return shortenedTestCaseName;
    }

    private static void accumulateTestSetStats(TestSetStats accumulated, Collection<WrappedReportEntry> reportEntries) {
        for (WrappedReportEntry entry : reportEntries) {
            switch (entry.getReportEntryType()) {
                case SUCCESS: {
                    accumulated.testSucceeded(entry);
                    break;
                }
                case SKIPPED: {
                    accumulated.testSkipped(entry);
                    break;
                }
                case FAILURE: {
                    accumulated.testFailure(entry);
                    break;
                }
                case ERROR: {
                    accumulated.testError(entry);
                }
            }
        }
    }

    public void reset() {
    }

    private static String getOuterTestClass(TestSetReportEntry report) {
        String source = report.getSourceName();
        int dollar = source.indexOf(36);
        if (dollar != -1) {
            source = source.substring(0, dollar);
        }
        return source;
    }
}

