/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.buildtools.surefire.junit;

import java.util.ArrayList;
import net.sourceforge.pmd.buildtools.surefire.junit.TestExecutionListener;
import org.apache.maven.surefire.api.provider.AbstractProvider;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.report.ConsoleOutputCapture;
import org.apache.maven.surefire.api.report.ReporterException;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnitPlatformProvider
extends AbstractProvider {
    private final ProviderParameters parameters;

    public JUnitPlatformProvider(ProviderParameters parameters) {
        this.parameters = parameters;
    }

    public Iterable<Class<?>> getSuites() {
        try (LauncherSession session = LauncherFactory.openSession();){
            TestsToRun testsToRun = this.findTests(session);
            return testsToRun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        RunResult result;
        ReporterFactory reporterFactory = this.parameters.getReporterFactory();
        TestExecutionListener testExecutionListener = new TestExecutionListener((TestReportListener<TestOutputReportEntry>)reporterFactory.createTestReportListener());
        ConsoleOutputCapture.startCapture((TestOutputReceiver)testExecutionListener);
        try (LauncherSession session = LauncherFactory.openSession();){
            TestsToRun testsToRun;
            if (forkTestSet instanceof TestsToRun) {
                testsToRun = (TestsToRun)forkTestSet;
            } else if (forkTestSet instanceof Class) {
                testsToRun = TestsToRun.fromClass((Class)((Class)forkTestSet));
            } else if (forkTestSet == null) {
                testsToRun = this.findTests(session);
            } else {
                throw new IllegalArgumentException("Invalid forkTestSet parameter: " + forkTestSet);
            }
            this.runTests(session, testsToRun, testExecutionListener);
        }
        finally {
            result = reporterFactory.close();
        }
        return result;
    }

    private void runTests(LauncherSession session, TestsToRun testsToRun, TestExecutionListener testExecutionListener) {
        ArrayList selectors = new ArrayList();
        testsToRun.iterator().forEachRemaining(testClass -> selectors.add(DiscoverySelectors.selectClass((Class)testClass)));
        Launcher launcher = session.getLauncher();
        TestPlan testPlan = launcher.discover(LauncherDiscoveryRequestBuilder.request().selectors(selectors).build());
        launcher.execute(testPlan, new org.junit.platform.launcher.TestExecutionListener[]{testExecutionListener});
    }

    private TestsToRun findTests(LauncherSession session) {
        ScanResult scanResult = this.parameters.getScanResult();
        TestListResolver testListResolver = this.parameters.getTestRequest().getTestListResolver();
        return scanResult.applyFilter(testClass -> {
            TestPlan testPlan = session.getLauncher().discover(LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((Class)testClass)}).filters(new Filter[]{className -> {
                String classFileName = TestListResolver.toClassFileName((String)className);
                boolean shouldRun = testListResolver.shouldRun(classFileName, null);
                return FilterResult.includedIf((boolean)shouldRun);
            }}).build());
            return testPlan.containsTests();
        }, this.parameters.getTestClassLoader());
    }
}

