/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.buildtools.surefire.junit;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import net.sourceforge.pmd.buildtools.surefire.junit.RootContainer;
import org.apache.maven.surefire.api.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.api.report.OutputReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;

class TestExecutionListener
implements org.junit.platform.launcher.TestExecutionListener,
TestOutputReceiver<OutputReportEntry> {
    private final AtomicLong testIdGenerator = new AtomicLong();
    private final Map<String, Long> testIdMapping = new ConcurrentHashMap<String, Long>();
    private final ThreadLocal<Long> currentRunId = new ThreadLocal();
    private final ConcurrentMap<String, RootContainer> rootContainers = new ConcurrentHashMap<String, RootContainer>();
    private final ConcurrentMap<TestIdentifier, Long> startTimes = new ConcurrentHashMap<TestIdentifier, Long>();
    private final TestReportListener<TestOutputReportEntry> testReportListener;

    TestExecutionListener(TestReportListener<TestOutputReportEntry> testReportListener) {
        this.testReportListener = testReportListener;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.determineRootContainer(testIdentifier).ifPresent(RootContainer::markHasAtLeastOneTest);
        this.testReportListener.testSkipped((ReportEntry)this.toReportEntry(testIdentifier));
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.startTimes.put(testIdentifier, System.currentTimeMillis());
        if (testIdentifier.isContainer()) {
            RootContainer previous;
            Optional<String> rootClass = this.determineRootClass(testIdentifier);
            if (rootClass.isPresent() && (previous = this.rootContainers.putIfAbsent(rootClass.get(), new RootContainer(testIdentifier))) == null) {
                this.testReportListener.testSetStarting((TestSetReportEntry)this.toTestSetReportEntry(testIdentifier, null));
            }
        } else {
            SimpleReportEntry reportEntry = this.toReportEntry(testIdentifier);
            this.testReportListener.testStarting((ReportEntry)reportEntry);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Map<String, String> systemProps = ManagementFactory.getRuntimeMXBean().getSystemProperties();
        Long startTime = (Long)this.startTimes.remove(testIdentifier);
        Integer elapsed = null;
        if (startTime != null) {
            elapsed = (int)(System.currentTimeMillis() - startTime);
        }
        if (testIdentifier.isContainer()) {
            RootContainer removed;
            Optional<String> rootClass = this.determineRootClass(testIdentifier);
            Optional<RootContainer> rootContainer = this.determineRootContainer(testIdentifier);
            if (rootClass.isPresent() && rootContainer.isPresent() && rootContainer.get().isIdentifier(testIdentifier) && (removed = (RootContainer)this.rootContainers.remove(rootClass.get())) != null) {
                if (removed.hasNoTests()) {
                    String message = "No Tests have been executed in Test Set";
                    this.testReportListener.testError((ReportEntry)this.toReportEntry(testIdentifier, message, new IllegalStateException(message), Collections.emptyMap(), null));
                }
                this.testReportListener.testSetCompleted((TestSetReportEntry)this.toTestSetReportEntry(testIdentifier, elapsed));
            }
        } else {
            String message = testExecutionResult.getThrowable().map(Throwable::getMessage).orElse(null);
            boolean isAssertionError = testExecutionResult.getThrowable().map(AssertionError.class::isInstance).orElse(false);
            SimpleReportEntry reportEntry = this.toReportEntry(testIdentifier, message, testExecutionResult.getThrowable().orElse(null), systemProps, elapsed);
            this.determineRootContainer(testIdentifier).ifPresent(RootContainer::markHasAtLeastOneTest);
            switch (testExecutionResult.getStatus()) {
                case SUCCESSFUL: {
                    this.testReportListener.testSucceeded((ReportEntry)reportEntry);
                    break;
                }
                case FAILED: {
                    if (isAssertionError) {
                        this.testReportListener.testFailed((ReportEntry)reportEntry);
                        break;
                    }
                    this.testReportListener.testError((ReportEntry)reportEntry);
                    break;
                }
                case ABORTED: {
                    this.testReportListener.testAssumptionFailure((ReportEntry)reportEntry);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown execution result status: " + testExecutionResult.getStatus());
                }
            }
        }
    }

    private long determineRunId(TestIdentifier testIdentifier) {
        return this.testIdMapping.computeIfAbsent(testIdentifier.getUniqueId(), id -> {
            long runId = this.testIdGenerator.incrementAndGet();
            this.currentRunId.set(runId);
            return runId;
        });
    }

    private Optional<String> determineRootClass(TestIdentifier testIdentifier) {
        Optional<String> classNameFromClassSource = testIdentifier.getSource().filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(ClassSource::getClassName);
        Optional<String> classNameFromMethodSource = testIdentifier.getSource().filter(MethodSource.class::isInstance).map(MethodSource.class::cast).map(MethodSource::getClassName);
        Optional<String> classNameFromUniqueId = testIdentifier.getUniqueIdObject().getSegments().stream().filter(s -> "class".equals(s.getType())).map(UniqueId.Segment::getValue).findFirst();
        if (classNameFromMethodSource.isPresent()) {
            return classNameFromMethodSource;
        }
        if (classNameFromClassSource.isPresent()) {
            return classNameFromClassSource;
        }
        return classNameFromUniqueId;
    }

    private Optional<RootContainer> determineRootContainer(TestIdentifier testIdentifier) {
        return this.determineRootClass(testIdentifier).map(this.rootContainers::get);
    }

    private SimpleReportEntry toReportEntry(TestIdentifier testIdentifier) {
        return this.toReportEntry(testIdentifier, null, null, Collections.emptyMap(), null);
    }

    private SimpleReportEntry toReportEntry(TestIdentifier testIdentifier, String message, Throwable throwable, Map<String, String> systemProps, Integer elapsed) {
        return new SimpleReportEntry(RunMode.NORMAL_RUN, Long.valueOf(this.determineRunId(testIdentifier)), testIdentifier.getDisplayName(), testIdentifier.getDisplayName(), testIdentifier.getUniqueId(), testIdentifier.getUniqueId(), (StackTraceWriter)(throwable != null ? new LegacyPojoStackTraceWriter(testIdentifier.getDisplayName(), null, throwable) : null), elapsed, message, systemProps);
    }

    private SimpleReportEntry toTestSetReportEntry(TestIdentifier testIdentifier, Integer elapsed) {
        String testClass = this.determineRootClass(testIdentifier).orElse(testIdentifier.getDisplayName());
        return new SimpleReportEntry(RunMode.NORMAL_RUN, Long.valueOf(this.determineRunId(testIdentifier)), testClass, testIdentifier.getDisplayName(), null, null, elapsed);
    }

    public void writeTestOutput(OutputReportEntry reportEntry) {
        Long testRunId = this.currentRunId.get();
        this.testReportListener.writeTestOutput((OutputReportEntry)new TestOutputReportEntry(reportEntry, RunMode.NORMAL_RUN, testRunId));
    }
}

