/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import net.sourceforge.pmd.build.PmdBuildException;
import net.sourceforge.pmd.build.PmdBuildTools;
import net.sourceforge.pmd.build.RuntimeRulePropertiesAnalyzer;
import net.sourceforge.pmd.build.filefilter.DirectoryFileFilter;
import net.sourceforge.pmd.build.filefilter.RulesetFilenameFilter;
import net.sourceforge.pmd.build.util.ConfigUtil;
import net.sourceforge.pmd.build.util.FileUtil;
import net.sourceforge.pmd.build.util.XmlUtil;
import net.sourceforge.pmd.build.xml.RulesetFileTemplater;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleSetToDocs
implements PmdBuildTools {
    private static final Logger LOGGER = Logger.getLogger(PmdBuildException.class.toString());
    private String indexRuleSetFilename = ConfigUtil.getString("pmd.build.config.index.filename");
    private String mergedRuleSetFilename = ConfigUtil.getString("pmd.build.config.mergedRuleset.filename");
    private String rulesDirectory;
    private String targetDirectory;
    private String siteXml;
    private String siteXmlTarget;
    private URL[] runtimeClasspath;
    private RuntimeRulePropertiesAnalyzer ruleAnalyzer;
    private RulesetFileTemplater xmlFileTemplater;

    public URL[] getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    @Override
    public void setRuntimeClasspath(URL[] runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
    }

    public String getSiteXmlTarget() {
        return this.siteXmlTarget;
    }

    @Override
    public void setSiteXmlTarget(String siteXmlTarget) {
        this.siteXmlTarget = siteXmlTarget;
    }

    @Override
    public String getRulesDirectory() {
        return this.rulesDirectory;
    }

    @Override
    public void setRulesDirectory(String rulesDirectory) {
        this.rulesDirectory = rulesDirectory;
    }

    public String getIndexRuleSetFilename() {
        return this.indexRuleSetFilename;
    }

    public void setIndexRuleSetFilename(String indexRuleSetFilename) {
        this.indexRuleSetFilename = indexRuleSetFilename;
    }

    public String getMergedRuleSetFilename() {
        return this.mergedRuleSetFilename;
    }

    public void setMergedRuleSetFilename(String mergedRuleSetFilename) {
        this.mergedRuleSetFilename = mergedRuleSetFilename;
    }

    @Override
    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public RulesetFileTemplater getXmlFileTemplater() {
        return this.xmlFileTemplater;
    }

    public void setXmlFileTemplater(RulesetFileTemplater xmlFileTemplater) {
        this.xmlFileTemplater = xmlFileTemplater;
    }

    public String getSiteXml() {
        return this.siteXml;
    }

    @Override
    public void setSiteXml(String siteXml) {
        this.siteXml = siteXml;
    }

    private void init() throws PmdBuildException {
        FileUtil.createDirIfMissing(this.targetDirectory);
        this.xmlFileTemplater = new RulesetFileTemplater(this.rulesDirectory);
        this.ruleAnalyzer = new RuntimeRulePropertiesAnalyzer(this.runtimeClasspath);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Merge xsl:" + this.xmlFileTemplater.getMergeRulesetXsl());
        }
    }

    @Override
    public void convertRulesets() throws PmdBuildException {
        this.init();
        File rulesDir = new File(this.rulesDirectory);
        if (rulesDir.exists() && rulesDir.isDirectory()) {
            this.recursivelyProcessSubFolder(this.processAllXDocsFilesFromDir(rulesDir));
        } else {
            if (!rulesDir.exists()) {
                throw new PmdBuildException("The rulesets directory specified '" + this.rulesDirectory + "' does not exist");
            }
            if (!rulesDir.isDirectory()) {
                throw new PmdBuildException("The rulesets directory '" + this.rulesDirectory + "' provided is not a directory !");
            }
        }
    }

    private void recursivelyProcessSubFolder(File rulesDir) throws PmdBuildException {
        for (File folder : FileUtil.filterFilesFrom(rulesDir, new DirectoryFileFilter())) {
            this.recursivelyProcessSubFolder(this.processAllXDocsFilesFromDir(folder));
        }
    }

    private File processAllXDocsFilesFromDir(File rulesDir) throws PmdBuildException {
        for (File ruleset : FileUtil.filterFilesFrom(rulesDir, new RulesetFilenameFilter())) {
            this.processXDocFile(ruleset);
        }
        return rulesDir;
    }

    private File buildTransformedRulesetDirectory(File ruleset) {
        return new File(this.targetDirectory + File.separator + ruleset.getParentFile().getName() + File.separator + FilenameUtils.getBaseName((String)ruleset.getName()) + ".md");
    }

    private void processXDocFile(File ruleset) throws PmdBuildException {
        File targetFile = this.buildTransformedRulesetDirectory(ruleset);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing file " + ruleset + " into " + targetFile.getAbsolutePath());
        }
        FileUtil.ensureTargetDirectoryExist(targetFile);
        this.convertRuleSetFile(ruleset, targetFile);
    }

    private void convertRuleSetFile(File ruleset, File target) throws PmdBuildException {
        try {
            DOMSource dom = XmlUtil.createDomSourceFrom(new FileInputStream(ruleset));
            Document document = (Document)dom.getNode();
            NodeList rules = document.getElementsByTagName("rule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Node rule = rules.item(i);
                this.ruleAnalyzer.analyze(document, rule);
                RuleSetToDocs.escapeTextContent(RuleSetToDocs.findChildren(rule, "example"));
                List<Node> properties = RuleSetToDocs.findChildren(rule, "properties");
                for (Node prop : properties) {
                    List<Node> property = RuleSetToDocs.findChildren(prop, "property");
                    for (Node n : property) {
                        if (!((Element)n).getAttribute("name").equals("xpath")) continue;
                        RuleSetToDocs.escapeTextContent(RuleSetToDocs.findChildren(n, "value"));
                    }
                }
            }
            this.xmlFileTemplater.transform(dom, target, this.xmlFileTemplater.getRulesetToDocsXsl());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static List<Node> findChildren(Node parent, String childName) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!RuleSetToDocs.isElement(child, childName)) continue;
            result.add(child);
        }
        return result;
    }

    private static boolean isElement(Node node, String name) {
        return node.getNodeType() == 1 && name.equals(node.getNodeName());
    }

    private static void escapeTextContent(Collection<Node> nodes) {
        for (Node node : nodes) {
            RuleSetToDocs.escapeTextContent(node);
        }
    }

    private static void escapeTextContent(Node node) {
        String content = node.getTextContent();
        content = content.replaceAll("&", "&amp;");
        content = content.replaceAll("<", "&lt;");
        node.setTextContent(content);
    }

    private void addRulesetsToSiteXml(DOMSource backbone) {
        File menu = FileUtil.createTempFile("menu.xml");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("menu file:" + menu.getAbsolutePath());
        }
        this.xmlFileTemplater.transform(backbone, menu, this.xmlFileTemplater.getCreateRulesetMenuXsl());
        File site = FileUtil.createTempFile("site.xml");
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("menufile", menu.getAbsoluteFile().toString());
        File sitePre = new File(this.siteXml);
        this.xmlFileTemplater.transform(sitePre, site, this.xmlFileTemplater.getAddToSiteDescriptorXsl(), parameters);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("new site describ:" + site.getAbsolutePath());
        }
        FileUtil.move(site, new File(this.getSiteXmlTarget()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("deleting file:" + site.getAbsolutePath());
        }
        FileUtil.deleteFile(site);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("deleting file:" + site.getAbsolutePath());
        }
        FileUtil.deleteFile(menu);
    }

    private DOMSource createMergedFile(File mergedFile) {
        DOMSource backbone = XmlUtil.createXmlBackbone(this.xmlFileTemplater);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(XmlUtil.transformDomToString(backbone));
        }
        this.xmlFileTemplater.transform(backbone, mergedFile, this.xmlFileTemplater.getMergeRulesetXsl());
        FileUtil.replaceAllInFile(mergedFile, "xmlns=\"http://pmd.sourceforge.net/ruleset/2.0.0\"", "");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating index file:" + this.indexRuleSetFilename + ", using merged file:" + mergedFile.toString());
        }
        return backbone;
    }

    @Override
    public void preSiteGeneration() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Merging all rules into " + this.mergedRuleSetFilename);
        }
        File mergedFile = new File(this.targetDirectory + File.separator + FileUtil.pathToParent + File.separator + this.mergedRuleSetFilename);
        DOMSource backbone = this.createMergedFile(mergedFile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating index file:" + this.indexRuleSetFilename + ", using merged file:" + mergedFile.toString());
        }
        this.xmlFileTemplater.transform(mergedFile, new File(this.targetDirectory + File.separator + this.indexRuleSetFilename), this.xmlFileTemplater.getGenerateIndexXsl());
        this.addRulesetsToSiteXml(backbone);
    }
}

