/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.build.filefilter;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class RulesetFilenameFilter
implements FilenameFilter {
    private static final Pattern EXCLUDE = Pattern.compile("(^[0-9][0-9].*\\.xml)|(^.*dogfood.*\\.xml)|(^all-.*\\.xml)|(^migrating_.*\\.xml)|(^pmdspecific.xml)");

    @Override
    public boolean accept(File file, String name) {
        if (this.doesNotMatchExcludeNames(name)) {
            return name.endsWith(".xml");
        }
        return false;
    }

    private boolean doesNotMatchExcludeNames(String name) {
        return !EXCLUDE.matcher(name).matches();
    }
}

