/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.net.URL;
import net.sourceforge.pmd.build.PmdBuildException;
import net.sourceforge.pmd.build.PmdBuildTools;
import net.sourceforge.pmd.build.RuleSetToDocs;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PmdBuildTask
extends Task {
    private String rulesDirectory;
    private String target;
    private String siteXml;
    private String siteXmlTarget;
    private URL[] runtimeClasspath;
    private String rulesetToDocs;
    private String mergeRuleset;
    private String rulesIndex;
    private String indexFilename;
    private String mergedRulesetFilename;

    public URL[] getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public void setRuntimeClasspath(URL[] runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
    }

    public String getSiteXml() {
        return this.siteXml;
    }

    public void setSiteXml(String siteXml) {
        this.siteXml = siteXml;
    }

    public String getSiteXmlTarget() {
        return this.siteXmlTarget;
    }

    public void setSiteXmlTarget(String siteXmlTarget) {
        this.siteXmlTarget = siteXmlTarget;
    }

    public String getRulesDirectory() {
        return this.rulesDirectory;
    }

    public void setRulesDirectory(String rulesDirectory) {
        this.rulesDirectory = rulesDirectory;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String targetDirectory) {
        this.target = targetDirectory;
    }

    public void execute() throws BuildException {
        PmdBuildTools tool = this.validate(new RuleSetToDocs());
        tool.setTargetDirectory(this.target);
        tool.setSiteXml(this.siteXml);
        tool.setSiteXmlTarget(this.siteXmlTarget);
        tool.setRulesDirectory(this.rulesDirectory);
        tool.setRuntimeClasspath(this.runtimeClasspath);
        try {
            tool.convertRulesets();
            tool.preSiteGeneration();
        }
        catch (PmdBuildException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private PmdBuildTools validate(RuleSetToDocs tool) throws BuildException {
        if (this.target == null || "".equals(this.target)) {
            throw new BuildException("Attribute targetDirectory is not optional");
        }
        if (this.rulesDirectory == null || "".equals(this.rulesDirectory)) {
            throw new BuildException("Attribute rulesDirectory is not optional");
        }
        if (this.siteXml == null || "".equals(this.siteXml)) {
            throw new BuildException("Attribute siteXml is not optional");
        }
        if (this.runtimeClasspath == null || "".equals(this.runtimeClasspath)) {
            throw new BuildException("Attribute pmdClasspath is not optional");
        }
        if (this.mergedRulesetFilename != null && !"".equals(this.mergedRulesetFilename)) {
            tool.setMergedRuleSetFilename(this.mergedRulesetFilename);
        }
        if (this.rulesIndex != null && !"".equals(this.rulesIndex)) {
            tool.getXmlFileTemplater().setGenerateIndexXsl(this.rulesIndex);
        }
        if (this.rulesetToDocs != null && !"".equals(this.rulesetToDocs)) {
            tool.getXmlFileTemplater().setRulesetToDocsXsl(this.rulesetToDocs);
        }
        if (this.mergeRuleset != null && !"".equals(this.mergeRuleset)) {
            tool.getXmlFileTemplater().setMergeRulesetXsl(this.mergeRuleset);
        }
        return tool;
    }

    public String getRulesetToDocs() {
        return this.rulesetToDocs;
    }

    public void setRulesetToDocs(String rulesetToDocs) {
        this.rulesetToDocs = rulesetToDocs;
    }

    public String getMergeRuleset() {
        return this.mergeRuleset;
    }

    public void setMergeRuleset(String mergeRuleset) {
        this.mergeRuleset = mergeRuleset;
    }

    public String getRulesIndex() {
        return this.rulesIndex;
    }

    public void setRulesIndex(String rulesIndex) {
        this.rulesIndex = rulesIndex;
    }

    public String getIndexFilename() {
        return this.indexFilename;
    }

    public void setIndexFilename(String indexFilename) {
        this.indexFilename = indexFilename;
    }

    public String getMergedRulesetFilename() {
        return this.mergedRulesetFilename;
    }

    public void setMergedRulesetFilename(String mergedRulesetFilename) {
        this.mergedRulesetFilename = mergedRulesetFilename;
    }
}

