/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.build;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuntimeRulePropertiesAnalyzer {
    private static final String XPATH_RULE_CLASSNAME = "net.sourceforge.pmd.lang.rule.XPathRule";
    private ClassLoader cl;
    private Method nameMethod;
    private Method descMethod;
    private Method defaultValueMethod;
    private Field propertiesField;
    private Field propertiesValues;

    public RuntimeRulePropertiesAnalyzer(URL[] runtimeClasspath) {
        this.init(runtimeClasspath);
    }

    private void init(URL[] runtimeClasspath) {
        try {
            this.cl = new URLClassLoader(runtimeClasspath);
            Class<?> propertySource = this.cl.loadClass("net.sourceforge.pmd.AbstractPropertySource");
            Class<?> propertyDesc = this.cl.loadClass("net.sourceforge.pmd.PropertyDescriptor");
            this.nameMethod = propertyDesc.getDeclaredMethod("name", new Class[0]);
            this.descMethod = propertyDesc.getDeclaredMethod("description", new Class[0]);
            this.defaultValueMethod = propertyDesc.getDeclaredMethod("defaultValue", new Class[0]);
            this.propertiesField = propertySource.getDeclaredField("propertyDescriptors");
            this.propertiesValues = propertySource.getDeclaredField("propertyValuesByDescriptor");
            this.propertiesField.setAccessible(true);
            this.propertiesValues.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void analyze(Document document, Node rule) {
        Node classAttribute = rule.getAttributes().getNamedItem("class");
        if (classAttribute == null) {
            return;
        }
        String classAtt = classAttribute.getTextContent();
        if (XPATH_RULE_CLASSNAME.equals(classAtt)) {
            return;
        }
        try {
            Class<?> clazz = this.cl.loadClass(classAtt);
            Object ruleInstance = clazz.newInstance();
            List properties = (List)this.propertiesField.get(ruleInstance);
            Map values = (Map)this.propertiesValues.get(ruleInstance);
            Element propsElem = null;
            NodeList ruleChilds = rule.getChildNodes();
            for (int j = 0; j < ruleChilds.getLength(); ++j) {
                Node item = ruleChilds.item(j);
                if (item.getNodeType() != 1 || !"properties".equals(item.getNodeName())) continue;
                propsElem = (Element)item;
                break;
            }
            if (propsElem == null) {
                propsElem = document.createElement("properties");
                rule.appendChild(propsElem);
            }
            for (Object o : properties) {
                Object value = values.get(o);
                if (value == null) {
                    value = this.defaultValueMethod.invoke(o, new Object[0]);
                }
                Element propElem = document.createElement("property");
                propElem.setAttribute("name", (String)this.nameMethod.invoke(o, new Object[0]));
                propElem.setAttribute("description", (String)this.descMethod.invoke(o, new Object[0]));
                if (value != null) {
                    String valueString = String.valueOf(value);
                    if (value.getClass().isArray()) {
                        valueString = Arrays.toString((Object[])value);
                    }
                    propElem.setAttribute("value", valueString);
                }
                propsElem.appendChild(propElem);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

