/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.build.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.build.PmdBuildException;

public final class FileUtil {
    public static String pathToParent = "..";

    private FileUtil() {
    }

    public static List<File> listFilesFrom(File dir) {
        return FileUtil.filterFilesFrom(dir, null);
    }

    public static List<File> filterFilesFrom(File dir, FilenameFilter filter) {
        File[] files;
        LinkedList<File> filteredFiles = new LinkedList<File>();
        if (dir != null && (files = dir.listFiles(filter)) != null && files.length > 0) {
            filteredFiles.addAll(Arrays.asList(files));
        }
        Collections.sort(filteredFiles);
        return filteredFiles;
    }

    public static File existAndIsADirectory(String dirname) {
        File rulesDir = new File(dirname);
        return rulesDir.exists() && rulesDir.isDirectory() ? rulesDir : null;
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void ensureTargetDirectoryExist(File filename) throws PmdBuildException {
        File parentDir = filename.getParentFile();
        if (parentDir == null) {
            throw new PmdBuildException("No parent directory for " + filename.getAbsolutePath());
        }
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
    }

    public static File createDirIfMissing(String dirname) {
        File dir = new File(dirname);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Target directory '" + dir.getAbsolutePath() + "' does not exist and can't be created");
        }
        if (dir.exists() && dir.isFile()) {
            throw new IllegalStateException("Target directory '" + dir.getAbsolutePath() + "' already exist and is a file.");
        }
        return dir;
    }

    public static void deleteFile(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            for (int nbFile = 0; nbFile < files.length; ++nbFile) {
                FileUtil.deleteFile(files[nbFile]);
            }
            file.delete();
        }
    }

    public static void replaceAllInFile(File file, String pattern, String replacement) {
        File tmp = new File(file + ".tmp");
        try {
            FileWriter fw = new FileWriter(tmp);
            FileReader fr = new FileReader(file);
            BufferedWriter bw = new BufferedWriter(fw);
            BufferedReader br = new BufferedReader(fr);
            while (br.ready()) {
                String line = br.readLine();
                line = line.replaceAll(pattern, replacement);
                bw.write(line);
            }
            fr.close();
            bw.flush();
            fw.close();
            FileUtil.copy(tmp, file);
            tmp.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File createTempFile(String filename) {
        try {
            return File.createTempFile(filename + "-", ".tmp");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File move(File source, File target) {
        if (target.exists()) {
            if (!target.canWrite()) {
                throw new IllegalArgumentException("Can't write on existing file " + target.getAbsolutePath());
            }
        } else if (target.delete()) {
            throw new IllegalStateException("Can't delete file" + target.getAbsolutePath());
        }
        try {
            target.createNewFile();
            FileUtil.copy(source, target);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't copy " + source.getAbsolutePath() + " over " + target.getAbsolutePath());
        }
        return target;
    }

    public static InputStream createInputStream(String filepath) {
        if (filepath == null || "".equals(filepath)) {
            return null;
        }
        File file = new File(filepath);
        if (!file.exists()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

