/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.maven;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.build.PmdBuildException;
import net.sourceforge.pmd.build.RuleSetToDocs;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="pmd-pre-site", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PRE_SITE)
public class PmdPreSite
extends AbstractMojo {
    @Parameter(property="pmd.siteXml", defaultValue="${basedir}/src/site/site.pre.xml")
    private String siteXml;
    @Parameter(property="pmd.siteXml.target", defaultValue="${basedir}/src/site/site.xml")
    private String siteXmlTarget;
    @Parameter(property="pmd.siteTarget", defaultValue="${project.build.directory}/generated-site/markdown/rules")
    private String target;
    @Parameter(property="pmd.rulesets", defaultValue="${basedir}/src/main/resources/rulesets")
    private String rulesetsDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        List<URL> runtimeClasspath = this.determineRuntimeClasspath();
        this.getLog().info((CharSequence)"PMD: site generation preparation");
        this.getLog().debug((CharSequence)("- target:" + this.target));
        this.getLog().debug((CharSequence)("- siteXml:" + this.siteXml));
        this.getLog().debug((CharSequence)("- rulesets:" + this.rulesetsDirectory));
        this.getLog().debug((CharSequence)(" -siteXmlTarget" + this.siteXmlTarget));
        RuleSetToDocs tool = new RuleSetToDocs();
        tool.setTargetDirectory(this.target);
        tool.setSiteXml(this.siteXml);
        tool.setRulesDirectory(this.rulesetsDirectory);
        tool.setSiteXmlTarget(this.siteXmlTarget);
        tool.setRuntimeClasspath(runtimeClasspath.toArray(new URL[runtimeClasspath.size()]));
        try {
            tool.convertRulesets();
            tool.preSiteGeneration();
        }
        catch (PmdBuildException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private List<URL> determineRuntimeClasspath() {
        ArrayList<URL> runtimeClasspath;
        try {
            runtimeClasspath = new ArrayList<URL>();
            runtimeClasspath.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            Set runtimeArtifacts = this.project.getArtifacts();
            for (Artifact a : runtimeArtifacts) {
                if (!"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
                runtimeClasspath.add(a.getFile().toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return runtimeClasspath;
    }
}

