/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.cli.commands.internal.AbstractAnalysisPmdSubcommand;
import net.sourceforge.pmd.cli.commands.typesupport.internal.CpdLanguageTypeSupport;
import net.sourceforge.pmd.cli.internal.CliExitCode;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.internal.LogMessages;
import net.sourceforge.pmd.internal.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="cpd", showDefaultValues=true, description={"Copy/Paste Detector - find duplicate code"})
public class CpdCommand
extends AbstractAnalysisPmdSubcommand {
    @CommandLine.Option(names={"--language", "-l"}, description={"The source code language.%nValid values: ${COMPLETION-CANDIDATES}"}, defaultValue="java", converter={CpdLanguageTypeSupport.class}, completionCandidates=CpdLanguageTypeSupport.class)
    private Language language;
    @CommandLine.Option(names={"--minimum-tokens"}, description={"The minimum token length which should be reported as a duplicate."}, required=true)
    private int minimumTokens;
    @CommandLine.Option(names={"--skip-duplicate-files"}, description={"Ignore multiple copies of files of the same name and length in comparison."})
    private boolean skipDuplicates;
    @CommandLine.Option(names={"--format", "-f"}, description={"Report format.%nValid values: ${COMPLETION-CANDIDATES}%nAlternatively, you can provide the fully qualified name of a custom CpdRenderer in the classpath."}, defaultValue="text", completionCandidates=CpdSupportedReportFormatsCandidates.class)
    private String rendererName;
    @CommandLine.Option(names={"--ignore-literals"}, description={"Ignore literal values such as numbers and strings when comparing text."})
    private boolean ignoreLiterals;
    @CommandLine.Option(names={"--ignore-identifiers"}, description={"Ignore names of classes, methods, variables, constants, etc. when comparing text."})
    private boolean ignoreIdentifiers;
    @CommandLine.Option(names={"--ignore-annotations"}, description={"Ignore language annotations when comparing text."})
    private boolean ignoreAnnotations;
    @CommandLine.Option(names={"--ignore-usings"}, description={"Ignore using directives in C#"})
    private boolean ignoreUsings;
    @CommandLine.Option(names={"--ignore-literal-sequences"}, description={"Ignore sequences of literals such as list initializers."})
    private boolean ignoreLiteralSequences;
    @CommandLine.Option(names={"--ignore-sequences"}, description={"Ignore sequences of identifiers and literals"})
    private boolean ignoreIdentifierAndLiteralSequences;
    @CommandLine.Option(names={"--skip-lexical-errors"}, description={"Skip files which can't be tokenized due to invalid characters, instead of aborting with an error."})
    private boolean skipLexicalErrors;
    @CommandLine.Option(names={"--no-skip-blocks"}, description={"Do not skip code blocks marked with --skip-blocks-pattern (e.g. #if 0 until #endif)."})
    private boolean noSkipBlocks;
    @CommandLine.Option(names={"--skip-blocks-pattern"}, description={"Pattern to find the blocks to skip. Start and End pattern separated by |."}, defaultValue="#if 0|#endif")
    private String skipBlocksPattern;
    @CommandLine.Option(names={"--exclude"}, arity="1..*", description={"Files to be excluded from the analysis"})
    private List<File> excludes;
    @CommandLine.Option(names={"--non-recursive"}, description={"Don't scan subdirectiories."})
    private boolean nonRecursive;

    public CPDConfiguration toConfiguration() {
        CPDConfiguration configuration = new CPDConfiguration();
        configuration.setExcludes(this.excludes);
        configuration.setFailOnViolation(this.failOnViolation);
        configuration.setFileListPath(this.fileListPath == null ? null : this.fileListPath.toString());
        configuration.setFiles(this.inputPaths == null ? null : this.inputPaths.stream().map(Path::toFile).collect(Collectors.toList()));
        configuration.setIgnoreAnnotations(this.ignoreAnnotations);
        configuration.setIgnoreIdentifiers(this.ignoreIdentifiers);
        configuration.setIgnoreLiterals(this.ignoreLiterals);
        configuration.setIgnoreLiteralSequences(this.ignoreLiteralSequences);
        configuration.setIgnoreUsings(this.ignoreUsings);
        configuration.setLanguage(this.language);
        configuration.setMinimumTileSize(this.minimumTokens);
        configuration.setNonRecursive(this.nonRecursive);
        configuration.setNoSkipBlocks(this.noSkipBlocks);
        configuration.setRendererName(this.rendererName);
        configuration.setSkipBlocksPattern(this.skipBlocksPattern);
        configuration.setSkipDuplicates(this.skipDuplicates);
        configuration.setSkipLexicalErrors(this.skipLexicalErrors);
        configuration.setSourceEncoding(this.encoding.getEncoding().name());
        configuration.setURI(this.uri == null ? null : this.uri.toString());
        configuration.postContruct();
        CPDConfiguration.setSystemProperties((CPDConfiguration)configuration);
        return configuration;
    }

    @Override
    protected CliExitCode execute() {
        Logger logger = LoggerFactory.getLogger(CpdCommand.class);
        CPDConfiguration configuration = this.toConfiguration();
        CPD cpd = new CPD(configuration);
        try {
            cpd.go();
            CPDReport report = cpd.toReport();
            configuration.getCPDReportRenderer().render(report, IOUtil.createWriter((Charset)Charset.defaultCharset(), null));
            if (cpd.getMatches().hasNext() && configuration.isFailOnViolation()) {
                return CliExitCode.VIOLATIONS_FOUND;
            }
        }
        catch (IOException | RuntimeException e) {
            logger.debug(e.toString(), (Throwable)e);
            logger.error(LogMessages.errorDetectedMessage((int)1, (String)"cpd"));
            return CliExitCode.ERROR;
        }
        return CliExitCode.OK;
    }

    private static final class CpdSupportedReportFormatsCandidates
    implements Iterable<String> {
        private CpdSupportedReportFormatsCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            return Arrays.stream(CPDConfiguration.getRenderers()).iterator();
        }
    }
}

