/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.internal;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.benchmark.TextTimingReportRenderer;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimingReport;
import net.sourceforge.pmd.cli.commands.internal.AbstractAnalysisPmdSubcommand;
import net.sourceforge.pmd.cli.commands.typesupport.internal.PmdLanguageTypeSupport;
import net.sourceforge.pmd.cli.commands.typesupport.internal.PmdLanguageVersionTypeSupport;
import net.sourceforge.pmd.cli.commands.typesupport.internal.RulePriorityTypeSupport;
import net.sourceforge.pmd.cli.internal.CliExitCode;
import net.sourceforge.pmd.cli.internal.ProgressBarListener;
import net.sourceforge.pmd.internal.LogMessages;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ReportStats;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.log.MessageReporter;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="check", showDefaultValues=true, description={"The PMD standard source code analyzer"})
public class PmdCommand
extends AbstractAnalysisPmdSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(PmdCommand.class);
    private List<String> rulesets;
    private Path ignoreListPath;
    private String format;
    private int threads;
    private boolean benchmark;
    private List<Path> relativizeRootPaths;
    private boolean showSuppressed;
    private String suppressMarker;
    private RulePriority minimumPriority;
    private Properties properties = new Properties();
    private Path reportFile;
    private List<LanguageVersion> languageVersion;
    private Language forceLanguage;
    private String auxClasspath;
    private boolean noRuleSetCompatibility;
    private Path cacheLocation;
    private boolean noCache;
    private boolean showProgressBar;

    @CommandLine.Option(names={"--rulesets", "-R"}, description={"Path to a ruleset xml file. The path may reference a resource on the classpath of the application, be a local file system path, or a URL. The option can be repeated, and multiple arguments separated by comma can be provided to a single occurrence of the option."}, required=true, split=",", arity="1..*")
    public void setRulesets(List<String> rulesets) {
        this.rulesets = rulesets;
    }

    @CommandLine.Option(names={"--ignore-list"}, description={"Path to a file containing a list of files to exclude from the analysis, one path per line. This option can be combined with --dir, --file-list and --uri."})
    public void setIgnoreListPath(Path ignoreListPath) {
        this.ignoreListPath = ignoreListPath;
    }

    @CommandLine.Option(names={"--format", "-f"}, description={"Report format.%nValid values: ${COMPLETION-CANDIDATES}%nAlternatively, you can provide the fully qualified name of a custom Renderer in the classpath."}, defaultValue="text", completionCandidates=PmdSupportedReportFormatsCandidates.class)
    public void setFormat(String format) {
        this.format = format;
    }

    @CommandLine.Option(names={"--benchmark", "-b"}, description={"Benchmark mode - output a benchmark report upon completion; default to System.err."})
    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    @CommandLine.Option(names={"--relativize-paths-with", "-z"}, description={"Path relative to which directories are rendered in the report. This option allows shortening directories in the report; without it, paths are rendered as mentioned in the source directory (option \"--dir\"). The option can be repeated, in which case the shortest relative path will be used. If the root path is mentioned (e.g. \"/\" or \"C:\\\"), then the paths will be rendered as absolute."}, arity="1..*", split=",")
    public void setRelativizePathsWith(List<Path> rootPaths) {
        this.relativizeRootPaths = rootPaths;
        for (Path path : this.relativizeRootPaths) {
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected a directory path for option '--relativize-paths-with', found a file: " + path);
        }
    }

    @CommandLine.Option(names={"--show-suppressed"}, description={"Report should show suppressed rule violations."})
    public void setShowSuppressed(boolean showSuppressed) {
        this.showSuppressed = showSuppressed;
    }

    @CommandLine.Option(names={"--suppress-marker"}, description={"Specifies the string that marks a line which PMD should ignore."}, defaultValue="NOPMD")
    public void setSuppressMarker(String suppressMarker) {
        this.suppressMarker = suppressMarker;
    }

    @CommandLine.Option(names={"--minimum-priority"}, description={"Rule priority threshold; rules with lower priority than configured here won't be used.%nValid values (case insensitive): ${COMPLETION-CANDIDATES}"}, defaultValue="Low", completionCandidates=RulePriorityTypeSupport.class, converter={RulePriorityTypeSupport.class})
    public void setMinimumPriority(RulePriority priority) {
        this.minimumPriority = priority;
    }

    @CommandLine.Option(names={"--property", "-P"}, description={"Key-value pair defining a property for the report format.%nSupported values for each report format:%n${sys:pmd-cli.pmd.report.properties.help}"}, completionCandidates=PmdReportPropertiesCandidates.class)
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @CommandLine.Option(names={"--report-file", "-r"}, description={"Path to a file to which report output is written. The file is created if it does not exist. If this option is not specified, the report is rendered to standard output."})
    public void setReportFile(Path reportFile) {
        this.reportFile = reportFile;
    }

    @CommandLine.Option(names={"--use-version"}, description={"The language version PMD should use when parsing source code.%nValid values: ${COMPLETION-CANDIDATES}"}, completionCandidates=PmdLanguageVersionTypeSupport.class, converter={PmdLanguageVersionTypeSupport.class})
    public void setLanguageVersion(List<LanguageVersion> languageVersion) {
        languageVersion.stream().collect(Collectors.groupingBy(LanguageVersion::getLanguage)).forEach((l, list) -> {
            if (list.size() > 1) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Can only set one version per language, but for language " + l.getName() + " multiple versions were provided " + list.stream().map(LanguageVersion::getTerseName).collect(Collectors.joining("', '", "'", "'")));
            }
        });
        this.languageVersion = languageVersion;
    }

    @CommandLine.Option(names={"--force-language"}, description={"Force a language to be used for all input files, irrespective of file names. When using this option, the automatic language selection by extension is disabled, and PMD tries to parse all input files with the given language's parser. Parsing errors are ignored.%nValid values: ${COMPLETION-CANDIDATES}"}, completionCandidates=PmdLanguageTypeSupport.class, converter={PmdLanguageTypeSupport.class})
    public void setForceLanguage(Language forceLanguage) {
        this.forceLanguage = forceLanguage;
    }

    @CommandLine.Option(names={"--aux-classpath"}, description={"Specifies the classpath for libraries used by the source code. This is used to resolve types in Java source files. The platform specific path delimiter (\":\" on Linux, \";\" on Windows) is used to separate the entries. Alternatively, a single 'file:' URL to a text file containing path elements on consecutive lines can be specified."})
    public void setAuxClasspath(String auxClasspath) {
        this.auxClasspath = auxClasspath;
    }

    @CommandLine.Option(names={"--no-ruleset-compatibility"}, description={"Disable the ruleset compatibility filter. The filter is active by default and tries automatically 'fix' old ruleset files with old rule names"})
    public void setNoRuleSetCompatibility(boolean noRuleSetCompatibility) {
        this.noRuleSetCompatibility = noRuleSetCompatibility;
    }

    @CommandLine.Option(names={"--cache"}, description={"Specify the location of the cache file for incremental analysis. This should be the full path to the file, including the desired file name (not just the parent directory). If the file doesn't exist, it will be created on the first run. The file will be overwritten on each run with the most up-to-date rule violations."})
    public void setCacheLocation(Path cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    @CommandLine.Option(names={"--no-cache"}, description={"Explicitly disable incremental analysis. The '-cache' option is ignored if this switch is present in the command line."})
    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    @CommandLine.Option(names={"--threads", "-t"}, description={"Sets the number of threads used by PMD."}, defaultValue="1")
    public void setThreads(int threads) {
        if (threads < 0) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Thread count should be a positive number or zero, found " + threads + " instead.");
        }
        this.threads = threads;
    }

    @CommandLine.Option(names={"--no-progress"}, negatable=true, defaultValue="true", description={"Enables / disables progress bar indicator of live analysis progress."})
    public void setShowProgressBar(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
    }

    public PMDConfiguration toConfiguration() {
        PMDConfiguration configuration = new PMDConfiguration();
        if (this.inputPaths != null) {
            configuration.setInputPathList(this.inputPaths);
        }
        configuration.setInputFilePath(this.fileListPath);
        configuration.setIgnoreFilePath(this.ignoreListPath);
        configuration.setInputUri(this.uri);
        configuration.setReportFormat(this.format);
        configuration.setSourceEncoding(this.encoding.getEncoding().name());
        configuration.setMinimumPriority(this.minimumPriority);
        configuration.setReportFile(this.reportFile);
        configuration.setReportProperties(this.properties);
        if (this.relativizeRootPaths != null) {
            configuration.addRelativizeRoots(this.relativizeRootPaths);
        }
        configuration.setRuleSets(this.rulesets);
        configuration.setRuleSetFactoryCompatibilityEnabled(!this.noRuleSetCompatibility);
        configuration.setShowSuppressedViolations(this.showSuppressed);
        configuration.setSuppressMarker(this.suppressMarker);
        configuration.setThreads(this.threads);
        configuration.setFailOnViolation(this.failOnViolation);
        configuration.setAnalysisCacheLocation(this.cacheLocation != null ? this.cacheLocation.toString() : null);
        configuration.setIgnoreIncrementalAnalysis(this.noCache);
        if (this.languageVersion != null) {
            configuration.setDefaultLanguageVersions(this.languageVersion);
        }
        if (this.forceLanguage != null) {
            LanguageVersion forcedLangVer = configuration.getLanguageVersionDiscoverer().getDefaultLanguageVersion(this.forceLanguage);
            configuration.setForceLanguageVersion(forcedLangVer);
        }
        configuration.setReporter((MessageReporter)new SimpleMessageReporter(LoggerFactory.getLogger(PmdCommand.class)));
        try {
            configuration.prependAuxClasspath(this.auxClasspath);
        }
        catch (IllegalArgumentException e) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid auxiliary classpath: " + e.getMessage(), (Throwable)e);
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CliExitCode execute() {
        if (this.benchmark) {
            TimeTracker.startGlobalTracking();
        }
        PMDConfiguration configuration = this.toConfiguration();
        MessageReporter pmdReporter = configuration.getReporter();
        try {
            CliExitCode cliExitCode;
            block26: {
                PmdAnalysis pmd;
                block24: {
                    CliExitCode cliExitCode2;
                    block25: {
                        ReportStats stats;
                        block22: {
                            CliExitCode cliExitCode3;
                            block23: {
                                pmd = null;
                                try {
                                    try {
                                        pmd = PmdAnalysis.create((PMDConfiguration)configuration);
                                    }
                                    catch (Exception e) {
                                        pmdReporter.errorEx("Could not initialize analysis", (Throwable)e);
                                        CliExitCode cliExitCode4 = CliExitCode.ERROR;
                                        if (pmd != null) {
                                            pmd.close();
                                        }
                                        this.finishBenchmarker(pmdReporter);
                                        return cliExitCode4;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (pmd != null) {
                                            pmd.close();
                                        }
                                        throw throwable;
                                    }
                                    catch (Exception e) {
                                        pmdReporter.errorEx("Exception while running PMD.", (Throwable)e);
                                        this.printErrorDetected(pmdReporter, 1);
                                        CliExitCode cliExitCode5 = CliExitCode.ERROR;
                                        return cliExitCode5;
                                    }
                                }
                                LOG.debug("Current classpath:\n{}", (Object)System.getProperty("java.class.path"));
                                if (this.showProgressBar) {
                                    if (this.reportFile == null) {
                                        pmdReporter.warn("Progressbar rendering conflicts with reporting to STDOUT. No progressbar will be shown. Try running with argument '-r <file>' to output the report to a file instead.", new Object[0]);
                                    } else {
                                        pmd.addListener((GlobalAnalysisListener)new ProgressBarListener());
                                    }
                                }
                                stats = pmd.runAndReturnStats();
                                if (pmdReporter.numErrors() <= 0) break block22;
                                cliExitCode3 = CliExitCode.ERROR;
                                if (pmd == null) break block23;
                                pmd.close();
                            }
                            return cliExitCode3;
                        }
                        if (stats.getNumViolations() <= 0 || !configuration.isFailOnViolation()) break block24;
                        cliExitCode2 = CliExitCode.VIOLATIONS_FOUND;
                        if (pmd == null) break block25;
                        pmd.close();
                    }
                    return cliExitCode2;
                }
                cliExitCode = CliExitCode.OK;
                if (pmd == null) break block26;
                pmd.close();
            }
            return cliExitCode;
        }
        finally {
            this.finishBenchmarker(pmdReporter);
        }
    }

    private void printErrorDetected(MessageReporter reporter, int errors) {
        String msg = LogMessages.errorDetectedMessage((int)errors, (String)"pmd");
        reporter.info(StringUtil.quoteMessageFormat((String)msg), new Object[0]);
    }

    private void finishBenchmarker(MessageReporter pmdReporter) {
        if (this.benchmark) {
            TimingReport timingReport = TimeTracker.stopGlobalTracking();
            TextTimingReportRenderer renderer = new TextTimingReportRenderer();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(System.err);
                renderer.render(timingReport, (Writer)writer);
            }
            catch (IOException e) {
                pmdReporter.errorEx("Error producing benchmark report", (Throwable)e);
            }
        }
    }

    static {
        Properties emptyProps = new Properties();
        StringBuilder reportPropertiesHelp = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        for (String rendererName : RendererFactory.supportedRenderers()) {
            Renderer renderer = RendererFactory.createRenderer((String)rendererName, (Properties)emptyProps);
            if (renderer.getPropertyDescriptors().isEmpty()) continue;
            reportPropertiesHelp.append(rendererName + ":" + lineSeparator);
            for (PropertyDescriptor property : renderer.getPropertyDescriptors()) {
                reportPropertiesHelp.append("  ").append(property.name()).append(" - ").append(property.description()).append(lineSeparator);
                Object deflt = property.defaultValue();
                if (deflt == null || "".equals(deflt)) continue;
                reportPropertiesHelp.append("    Default: ").append(deflt).append(lineSeparator);
            }
        }
        System.setProperty("pmd-cli.pmd.report.properties.help", reportPropertiesHelp.toString());
    }

    private static final class PmdReportPropertiesCandidates
    implements Iterable<String> {
        private PmdReportPropertiesCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            ArrayList<String> propertyNames = new ArrayList<String>();
            Properties emptyProps = new Properties();
            for (String rendererName : RendererFactory.supportedRenderers()) {
                Renderer renderer = RendererFactory.createRenderer((String)rendererName, (Properties)emptyProps);
                for (PropertyDescriptor property : renderer.getPropertyDescriptors()) {
                    propertyNames.add(property.name());
                }
            }
            return propertyNames.iterator();
        }
    }

    private static final class PmdSupportedReportFormatsCandidates
    implements Iterable<String> {
        private PmdSupportedReportFormatsCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            return RendererFactory.supportedRenderers().iterator();
        }
    }
}

