/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.pmd.cli.commands.internal.AbstractPmdSubcommand;
import net.sourceforge.pmd.cli.commands.mixins.internal.EncodingMixin;
import net.sourceforge.pmd.cli.commands.typesupport.internal.PmdLanguageTypeSupport;
import net.sourceforge.pmd.cli.internal.CliExitCode;
import net.sourceforge.pmd.internal.LogMessages;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import net.sourceforge.pmd.util.treeexport.TreeExportConfiguration;
import net.sourceforge.pmd.util.treeexport.TreeExporter;
import net.sourceforge.pmd.util.treeexport.TreeRendererDescriptor;
import net.sourceforge.pmd.util.treeexport.TreeRenderers;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ast-dump", description={"Experimental: dumps the AST of parsing source code"})
public class TreeExportCommand
extends AbstractPmdSubcommand {
    @CommandLine.Mixin
    private EncodingMixin encoding;
    @CommandLine.Option(names={"--format", "-f"}, defaultValue="xml", description={"The output format.%nValid values: ${COMPLETION-CANDIDATES}"}, completionCandidates=TreeRenderersCandidates.class)
    private String format;
    @CommandLine.Option(names={"--language", "-l"}, defaultValue="java", description={"The source code language.%nValid values: ${COMPLETION-CANDIDATES}"}, completionCandidates=PmdLanguageTypeSupport.class, converter={PmdLanguageTypeSupport.class})
    private Language language;
    @CommandLine.Option(names={"-P"}, description={"Key-value pair defining a property for the report format.%nSupported values for each report format:%n${sys:pmd-cli.tree-export.report.properties.help}"}, completionCandidates=TreeExportReportPropertiesCandidates.class)
    private Properties properties = new Properties();
    @CommandLine.Option(names={"--file"}, description={"The file to parse and dump."})
    private Path file;
    @CommandLine.Option(names={"--read-stdin", "-i"}, description={"Read source from standard input."})
    private boolean readStdin;

    public TreeExportConfiguration toConfiguration() {
        TreeExportConfiguration configuration = new TreeExportConfiguration();
        configuration.setFile(this.file);
        configuration.setFormat(this.format);
        configuration.setLanguage(this.language);
        configuration.setProperties(this.properties);
        configuration.setReadStdin(this.readStdin);
        configuration.setSourceEncoding(this.encoding.getEncoding().name());
        return configuration;
    }

    @Override
    protected void validate() throws CommandLine.ParameterException {
        super.validate();
        if (this.file == null && !this.readStdin) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "One of --file or --read-stdin must be used.");
        }
    }

    @Override
    protected CliExitCode execute() {
        TreeExporter exporter = new TreeExporter(this.toConfiguration());
        try {
            exporter.export();
            return CliExitCode.OK;
        }
        catch (IOException e) {
            SimpleMessageReporter reporter = new SimpleMessageReporter(LoggerFactory.getLogger(TreeExportCommand.class));
            reporter.error((Throwable)e, LogMessages.errorDetectedMessage((int)1, (String)"ast-dump"), new Object[0]);
            return CliExitCode.ERROR;
        }
    }

    static {
        StringBuilder reportPropertiesHelp = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        for (TreeRendererDescriptor renderer : TreeRenderers.registeredRenderers()) {
            PropertySource propertyBundle = renderer.newPropertyBundle();
            if (propertyBundle.getPropertyDescriptors().isEmpty()) continue;
            reportPropertiesHelp.append(renderer.id() + ":" + lineSeparator);
            for (PropertyDescriptor property : propertyBundle.getPropertyDescriptors()) {
                reportPropertiesHelp.append("  ").append(property.name()).append(" - ").append(property.description()).append(lineSeparator);
                Object deflt = property.defaultValue();
                if (deflt == null || "".equals(deflt)) continue;
                reportPropertiesHelp.append("    Default: ").append(StringUtil.escapeWhitespace((Object)deflt)).append(lineSeparator);
            }
        }
        System.setProperty("pmd-cli.tree-export.report.properties.help", reportPropertiesHelp.toString());
    }

    private static final class TreeExportReportPropertiesCandidates
    implements Iterable<String> {
        private TreeExportReportPropertiesCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            ArrayList<String> propertyNames = new ArrayList<String>();
            for (TreeRendererDescriptor renderer : TreeRenderers.registeredRenderers()) {
                PropertySource propertyBundle = renderer.newPropertyBundle();
                for (PropertyDescriptor property : propertyBundle.getPropertyDescriptors()) {
                    propertyNames.add(property.name());
                }
            }
            return propertyNames.iterator();
        }
    }

    private static final class TreeRenderersCandidates
    implements Iterable<String> {
        private TreeRenderersCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            return TreeRenderers.registeredRenderers().stream().map(TreeRendererDescriptor::id).iterator();
        }
    }
}

