/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.internal;

import java.util.concurrent.atomic.AtomicInteger;
import me.tongfei.progressbar.PmdProgressBarFriend;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarStyle;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ListenerInitializer;

public final class ProgressBarListener
implements GlobalAnalysisListener {
    private ProgressBar progressBar;
    private final AtomicInteger numErrors = new AtomicInteger(0);
    private final AtomicInteger numViolations = new AtomicInteger(0);

    public ListenerInitializer initializer() {
        return new ListenerInitializer(){

            public void setNumberOfFilesToAnalyze(int totalFiles) {
                ProgressBarListener.this.progressBar = new ProgressBarBuilder().setTaskName("Processing files").setStyle(ProgressBarStyle.ASCII).hideEta().continuousUpdate().setInitialMax((long)totalFiles).setConsumer((ProgressBarConsumer)PmdProgressBarFriend.createConsoleConsumer(System.out)).clearDisplayOnFinish().build();
                ProgressBarListener.this.progressBar.setExtraMessage(ProgressBarListener.this.extraMessage());
            }
        };
    }

    private void refreshProgressBar() {
        this.progressBar.setExtraMessage(this.extraMessage());
        this.progressBar.refresh();
    }

    private String extraMessage() {
        return String.format("Violations:%d, Errors:%d", this.numViolations.get(), this.numErrors.get());
    }

    public FileAnalysisListener startFileAnalysis(TextFile file) {
        return new FileAnalysisListener(){

            public void onRuleViolation(RuleViolation violation) {
                ProgressBarListener.this.numViolations.addAndGet(1);
            }

            public void onSuppressedRuleViolation(Report.SuppressedViolation violation) {
            }

            public void onError(Report.ProcessingError error) {
                ProgressBarListener.this.numErrors.addAndGet(1);
            }

            public void close() {
                ProgressBarListener.this.progressBar.step();
                ProgressBarListener.this.refreshProgressBar();
            }
        };
    }

    public void close() throws Exception {
        this.progressBar.close();
    }
}

