/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.typesupport.internal;

import java.util.Iterator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import picocli.CommandLine;

public class PmdLanguageVersionTypeSupport
implements CommandLine.ITypeConverter<LanguageVersion>,
Iterable<String> {
    @Override
    public Iterator<String> iterator() {
        return LanguageRegistry.PMD.getLanguages().stream().flatMap(l -> l.getVersionNamesAndAliases().stream().map(v -> l.getId() + "-" + v)).collect(Collectors.toCollection(TreeSet::new)).iterator();
    }

    public LanguageVersion convert(String value) throws Exception {
        return LanguageRegistry.PMD.getLanguages().stream().filter(l -> value.startsWith(l.getId() + "-")).map(l -> l.getVersion(value.substring(l.getId().length() + 1))).filter(Objects::nonNull).findFirst().orElseThrow(() -> new CommandLine.TypeConversionException("Unknown language version: " + value));
    }
}

