/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.internal;

import java.util.function.Function;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.internal.Slf4jSimpleConfiguration;
import net.sourceforge.pmd.util.log.PmdReporter;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class PmdRootLogger {
    private static final String PMD_CLI_LOGGER = "net.sourceforge.pmd.cli";
    private static Logger log = LoggerFactory.getLogger((String)"net.sourceforge.pmd.cli");

    private PmdRootLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <C extends AbstractConfiguration, R> R executeInLoggingContext(C conf, boolean isDebug, Function<C, R> runnable) {
        Level curLogLevel = Slf4jSimpleConfiguration.getDefaultLogLevel();
        boolean resetLogLevel = false;
        try {
            if (isDebug) {
                Slf4jSimpleConfiguration.reconfigureDefaultLogLevel((Level)Level.TRACE);
                log = LoggerFactory.getLogger((String)PMD_CLI_LOGGER);
                resetLogLevel = true;
                Level defaultLogLevel = Slf4jSimpleConfiguration.getDefaultLogLevel();
                log.debug("Log level is at {}", (Object)defaultLogLevel);
            }
            PmdReporter pmdReporter = PmdRootLogger.setupMessageReporter();
            conf.setReporter(pmdReporter);
            R r = runnable.apply(conf);
            return r;
        }
        finally {
            if (resetLogLevel) {
                Slf4jSimpleConfiguration.reconfigureDefaultLogLevel((Level)curLogLevel);
                log = LoggerFactory.getLogger((String)PMD_CLI_LOGGER);
            }
        }
    }

    private static @NonNull PmdReporter setupMessageReporter() {
        SimpleMessageReporter pmdReporter = new SimpleMessageReporter(log);
        Slf4jSimpleConfiguration.installJulBridge();
        return pmdReporter;
    }
}

