/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;

final class RendererHelper {
    private RendererHelper() {
    }

    static void render(Iterator<Match> matches, Writer writer, CPDReportRenderer renderer) throws IOException {
        ArrayList matchesList = new ArrayList();
        matches.forEachRemaining(matchesList::add);
        ArrayList<TextFile> textFiles = new ArrayList<TextFile>();
        HashSet<String> paths = new HashSet<String>();
        for (Match match : matchesList) {
            for (Mark mark : match.getMarkSet()) {
                paths.add(mark.getFilename());
            }
        }
        for (String path : paths) {
            textFiles.add(TextFile.forPath((Path)Paths.get(path, new String[0]), (Charset)StandardCharsets.UTF_8, (LanguageVersion)JavaLanguageModule.getInstance().getDefaultVersion()));
        }
        try (SourceManager sourceManager = new SourceManager(textFiles);){
            CPDReport report = new CPDReport(sourceManager, matchesList, Collections.emptyMap());
            renderer.render(report, writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

