/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.internal.util.FileFinder;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.document.FileCollector;

public class CPD {
    private final CPDConfiguration configuration;
    private final List<Path> files = new ArrayList<Path>();
    private Set<String> current = new HashSet<String>();
    private CPDReport report;

    public CPD(CPDConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addAllInDirectory(File dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(File dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List<File> files) throws IOException {
        for (File f : files) {
            this.add(f);
        }
    }

    private void addDirectory(File dir, boolean recurse) throws IOException {
        if (!dir.exists()) {
            throw new FileNotFoundException("Couldn't find directory " + dir);
        }
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.configuration.filenameFilter(), recurse));
    }

    public void add(File file) throws IOException {
        if (this.configuration.isSkipDuplicates()) {
            String signature = file.getName() + '_' + file.length();
            if (this.current.contains(signature)) {
                System.err.println("Skipping " + file.getAbsolutePath() + " since it appears to be a duplicate file and --skip-duplicate-files is set");
                return;
            }
            this.current.add(signature);
        }
        if (!IOUtil.equalsNormalizedPaths((String)file.getAbsoluteFile().getCanonicalPath(), (String)file.getAbsolutePath())) {
            System.err.println("Skipping " + file + " since it appears to be a symlink");
            return;
        }
        if (!file.exists()) {
            System.err.println("Skipping " + file + " since it doesn't exist (broken symlink?)");
            return;
        }
        this.files.add(file.toPath());
    }

    public void go() {
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)this.configuration);){
            this.files.forEach(arg_0 -> ((FileCollector)cpd.files()).addFile(arg_0));
            cpd.performAnalysis(this::collectReport);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void collectReport(CPDReport cpdReport) {
        this.report = cpdReport;
    }

    public Iterator<Match> getMatches() {
        return this.report.getMatches().iterator();
    }
}

