/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.annotation.DeprecatedUntil700;
import net.sourceforge.pmd.cache.internal.AnalysisCache;
import net.sourceforge.pmd.cache.internal.FileAnalysisCache;
import net.sourceforge.pmd.cache.internal.NoopAnalysisCache;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.LoggerFactory;

public class PMDConfiguration
extends AbstractConfiguration {
    private static final LanguageRegistry DEFAULT_REGISTRY = LanguageRegistry.PMD;
    public static final String DEFAULT_SUPPRESS_MARKER = "NOPMD";
    private Path reportFile;
    private String suppressMarker = "NOPMD";
    private int threads = Runtime.getRuntime().availableProcessors();
    private ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private List<String> ruleSets = new ArrayList<String>();
    private RulePriority minimumPriority = RulePriority.LOW;
    private boolean ruleSetFactoryCompatibilityEnabled = true;
    private String reportFormat;
    private Properties reportProperties = new Properties();
    private boolean showSuppressedViolations = false;
    private boolean failOnViolation = true;
    private AnalysisCache analysisCache = new NoopAnalysisCache();
    private boolean ignoreIncrementalAnalysis;

    public PMDConfiguration() {
        this(DEFAULT_REGISTRY);
    }

    public PMDConfiguration(@NonNull LanguageRegistry languageRegistry) {
        super(languageRegistry, (PmdReporter)new SimpleMessageReporter(LoggerFactory.getLogger(PmdAnalysis.class)));
    }

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public void setSuppressMarker(String suppressMarker) {
        Objects.requireNonNull(suppressMarker, "Suppress marker was null");
        this.suppressMarker = suppressMarker;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
    }

    @Deprecated
    public void prependClasspath(String classpath) throws IOException {
        try {
            this.prependAuxClasspath(classpath);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public void prependAuxClasspath(String classpath) {
        try {
            if (this.classLoader == null) {
                this.classLoader = PMDConfiguration.class.getClassLoader();
            }
            if (classpath != null) {
                this.classLoader = new ClasspathClassLoader(classpath, this.classLoader);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Deprecated
    @DeprecatedUntil700
    public @Nullable String getRuleSets() {
        if (this.ruleSets.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", this.ruleSets);
    }

    public @NonNull List<@NonNull String> getRuleSetPaths() {
        return this.ruleSets;
    }

    public void setRuleSets(@NonNull List<@NonNull String> ruleSetPaths) {
        AssertionUtil.requireParamNotNull((String)"ruleSetPaths", ruleSetPaths);
        AssertionUtil.requireContainsNoNullValue((String)"ruleSetPaths", ruleSetPaths);
        this.ruleSets = new ArrayList<String>(ruleSetPaths);
    }

    public void addRuleSet(@NonNull String rulesetPath) {
        AssertionUtil.requireParamNotNull((String)"rulesetPath", (Object)rulesetPath);
        this.ruleSets.add(rulesetPath);
    }

    @Deprecated
    @DeprecatedUntil700
    public void setRuleSets(@Nullable String ruleSets) {
        this.ruleSets = ruleSets == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(ruleSets.split(",")));
    }

    public RulePriority getMinimumPriority() {
        return this.minimumPriority;
    }

    public void setMinimumPriority(RulePriority minimumPriority) {
        this.minimumPriority = minimumPriority;
    }

    public void setMinimumPriority(net.sourceforge.pmd.lang.rule.RulePriority mininumPriority) {
        this.minimumPriority = RulePriority.valueOf(mininumPriority.name());
    }

    public Renderer createRenderer() {
        return this.createRenderer(false);
    }

    public Renderer createRenderer(boolean withReportWriter) {
        Renderer renderer = RendererFactory.createRenderer((String)this.reportFormat, (Properties)this.reportProperties);
        renderer.setShowSuppressedViolations(this.showSuppressedViolations);
        if (withReportWriter) {
            renderer.setReportFile(this.getReportFile());
        }
        return renderer;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isShowSuppressedViolations() {
        return this.showSuppressedViolations;
    }

    public void setShowSuppressedViolations(boolean showSuppressedViolations) {
        this.showSuppressedViolations = showSuppressedViolations;
    }

    public Properties getReportProperties() {
        return this.reportProperties;
    }

    public void setReportProperties(Properties reportProperties) {
        this.reportProperties = reportProperties;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public boolean isRuleSetFactoryCompatibilityEnabled() {
        return this.ruleSetFactoryCompatibilityEnabled;
    }

    public void setRuleSetFactoryCompatibilityEnabled(boolean ruleSetFactoryCompatibilityEnabled) {
        this.ruleSetFactoryCompatibilityEnabled = ruleSetFactoryCompatibilityEnabled;
    }

    public AnalysisCache getAnalysisCache() {
        if (this.analysisCache == null || this.isIgnoreIncrementalAnalysis() && !(this.analysisCache instanceof NoopAnalysisCache)) {
            this.setAnalysisCache((AnalysisCache)new NoopAnalysisCache());
        }
        return this.analysisCache;
    }

    public void setAnalysisCache(AnalysisCache cache) {
        this.analysisCache = cache == null ? new NoopAnalysisCache() : cache;
    }

    public void setAnalysisCacheLocation(String cacheLocation) {
        this.setAnalysisCache((AnalysisCache)(cacheLocation == null ? new NoopAnalysisCache() : new FileAnalysisCache(new File(cacheLocation))));
    }

    public void setIgnoreIncrementalAnalysis(boolean noCache) {
        this.ignoreIncrementalAnalysis = noCache;
    }

    public boolean isIgnoreIncrementalAnalysis() {
        return this.ignoreIncrementalAnalysis;
    }

    @Deprecated
    public String getReportFile() {
        return this.reportFile == null ? null : this.reportFile.toString();
    }

    public Path getReportFilePath() {
        return this.reportFile;
    }

    @Deprecated
    public void setReportFile(String reportFile) {
        this.reportFile = reportFile == null ? null : Paths.get(reportFile, new String[0]);
    }

    public void setReportFile(Path reportFile) {
        this.reportFile = reportFile;
    }

    @Deprecated
    public void setSourceEncoding(String sourceEncoding) {
        this.setSourceEncoding(Charset.forName(Objects.requireNonNull(sourceEncoding)));
    }

    @Deprecated
    public void setBenchmark(boolean benchmark) {
    }
}

