/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.annotation.DeprecatedUntil700;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.BaseResultProducingCloseable;
import net.sourceforge.pmd.util.Predicate;

public class Report {
    protected final List<RuleViolation> violations = Collections.synchronizedList(new ArrayList());
    protected final List<SuppressedViolation> suppressedRuleViolations = Collections.synchronizedList(new ArrayList());
    protected final List<ProcessingError> errors = Collections.synchronizedList(new ArrayList());
    protected final List<ConfigurationError> configErrors = Collections.synchronizedList(new ArrayList());

    @DeprecatedUntil700
    @InternalApi
    public Report() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @DeprecatedUntil700
    @InternalApi
    public void addRuleViolation(RuleViolation violation) {
        List<RuleViolation> list = this.violations;
        synchronized (list) {
            int index = Collections.binarySearch(this.violations, violation, RuleViolation.DEFAULT_COMPARATOR);
            this.violations.add(index < 0 ? -index - 1 : index, violation);
        }
    }

    private void addSuppressedViolation(SuppressedViolation sv) {
        this.suppressedRuleViolations.add(sv);
    }

    @Deprecated
    @DeprecatedUntil700
    @InternalApi
    public void addConfigError(ConfigurationError error) {
        this.configErrors.add(error);
    }

    @Deprecated
    @DeprecatedUntil700
    @InternalApi
    public void addError(ProcessingError error) {
        this.errors.add(error);
    }

    @Deprecated
    public void merge(Report r) {
        this.errors.addAll(r.errors);
        this.configErrors.addAll(r.configErrors);
        this.suppressedRuleViolations.addAll(r.suppressedRuleViolations);
        for (RuleViolation violation : r.getViolations()) {
            this.addRuleViolation(violation);
        }
    }

    public List<SuppressedViolation> getSuppressedViolations() {
        return Collections.unmodifiableList(this.suppressedRuleViolations);
    }

    public List<RuleViolation> getViolations() {
        return Collections.unmodifiableList(this.violations);
    }

    public List<ProcessingError> getProcessingErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<ConfigurationError> getConfigurationErrors() {
        return Collections.unmodifiableList(this.configErrors);
    }

    public static Report buildReport(Consumer<? super FileAnalysisListener> lambda) {
        return (Report)BaseResultProducingCloseable.using((BaseResultProducingCloseable)new ReportBuilderListener(), lambda);
    }

    @Experimental
    public Report filterViolations(java.util.function.Predicate<RuleViolation> filter) {
        Report copy = new Report();
        for (RuleViolation violation : this.violations) {
            if (!filter.test(violation)) continue;
            copy.addRuleViolation(violation);
        }
        copy.suppressedRuleViolations.addAll(this.suppressedRuleViolations);
        copy.errors.addAll(this.errors);
        copy.configErrors.addAll(this.configErrors);
        return copy;
    }

    @Experimental
    public Report union(Report other) {
        Report copy = new Report();
        for (RuleViolation violation : this.violations) {
            copy.addRuleViolation(violation);
        }
        for (RuleViolation violation : other.violations) {
            copy.addRuleViolation(violation);
        }
        copy.suppressedRuleViolations.addAll(this.suppressedRuleViolations);
        copy.suppressedRuleViolations.addAll(other.suppressedRuleViolations);
        copy.errors.addAll(this.errors);
        copy.errors.addAll(other.errors);
        copy.configErrors.addAll(this.configErrors);
        copy.configErrors.addAll(other.configErrors);
        return copy;
    }

    @Deprecated
    public Report filterViolations(Predicate<RuleViolation> filter) {
        java.util.function.Predicate<RuleViolation> javaPredicate = filter::test;
        return this.filterViolations(javaPredicate);
    }

    public static class GlobalReportBuilderListener
    extends BaseResultProducingCloseable<net.sourceforge.pmd.reporting.Report>
    implements GlobalAnalysisListener {
        private final net.sourceforge.pmd.reporting.Report report = new net.sourceforge.pmd.reporting.Report();

        public FileAnalysisListener startFileAnalysis(TextFile file) {
            return new ReportBuilderListener(this.report);
        }

        public void onConfigError(Report.ConfigurationError error) {
            this.report.addConfigError(error);
        }

        protected net.sourceforge.pmd.reporting.Report getResultImpl() {
            return this.report;
        }
    }

    public static class ReportBuilderListener
    extends BaseResultProducingCloseable<Report>
    implements FileAnalysisListener {
        private final Report report;

        public ReportBuilderListener() {
            this(new Report());
        }

        ReportBuilderListener(Report report) {
            this.report = report;
        }

        protected Report getResultImpl() {
            return this.report;
        }

        public void onRuleViolation(net.sourceforge.pmd.reporting.RuleViolation violation) {
            this.report.addRuleViolation(violation);
        }

        public void onSuppressedRuleViolation(Report.SuppressedViolation violation) {
            this.report.addSuppressedViolation(violation);
        }

        public void onError(Report.ProcessingError error) {
            this.report.addError(error);
        }

        public String toString() {
            return "ReportBuilderListener";
        }
    }

    public static class SuppressedViolation {
        private final RuleViolation rv;
        private final String userMessage;
        private final ViolationSuppressor suppressor;

        public SuppressedViolation(RuleViolation rv, ViolationSuppressor suppressor, String userMessage) {
            this.suppressor = suppressor;
            this.rv = rv;
            this.userMessage = userMessage;
        }

        public ViolationSuppressor getSuppressor() {
            return this.suppressor;
        }

        public RuleViolation getRuleViolation() {
            return this.rv;
        }

        public String getUserMessage() {
            return this.userMessage;
        }
    }

    public static class ProcessingError {
        private final Throwable error;
        private final FileId file;

        public ProcessingError(Throwable error, FileId file) {
            this.error = error;
            this.file = file;
        }

        public String getMsg() {
            return this.error.getClass().getSimpleName() + ": " + this.error.getMessage();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public String getDetail() {
            try (StringWriter stringWriter = new StringWriter();){
                PrintWriter writer = new PrintWriter(stringWriter);
                try {
                    this.error.printStackTrace(writer);
                    String string = stringWriter.toString();
                    writer.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FileId getFileId() {
            return this.file;
        }

        public Throwable getError() {
            return this.error;
        }

        public String getFile() {
            return this.file.getAbsolutePath();
        }
    }

    public static class ConfigurationError {
        private final Rule rule;
        private final String issue;

        public ConfigurationError(Rule theRule, String theIssue) {
            this.rule = theRule;
            this.issue = theIssue;
        }

        public Rule rule() {
            return this.rule;
        }

        public String issue() {
            return this.issue;
        }
    }
}

