/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.RendererHelper;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import net.sourceforge.pmd.lang.document.FileLocation;
import org.apache.commons.lang3.StringEscapeUtils;

public class CSVRenderer
implements CPDReportRenderer,
CPDRenderer {
    private final char separator;
    private final boolean lineCountPerFile;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final boolean DEFAULT_LINECOUNTPERFILE = false;

    public CSVRenderer() {
        this(',', false);
    }

    public CSVRenderer(boolean lineCountPerFile) {
        this(',', lineCountPerFile);
    }

    public CSVRenderer(char separatorChar) {
        this(separatorChar, false);
    }

    public CSVRenderer(char separatorChar, boolean lineCountPerFile) {
        this.separator = separatorChar;
        this.lineCountPerFile = lineCountPerFile;
    }

    public void render(CPDReport report, Writer writer) throws IOException {
        if (!this.lineCountPerFile) {
            writer.append("lines").append(this.separator);
        }
        writer.append("tokens").append(this.separator).append("occurrences").append(System.lineSeparator());
        for (Match match : report.getMatches()) {
            if (!this.lineCountPerFile) {
                writer.append(String.valueOf(match.getLineCount())).append(this.separator);
            }
            writer.append(String.valueOf(match.getTokenCount())).append(this.separator).append(String.valueOf(match.getMarkCount())).append(this.separator);
            Iterator marks = match.iterator();
            while (marks.hasNext()) {
                Mark mark = (Mark)marks.next();
                FileLocation loc = mark.getLocation();
                writer.append(String.valueOf(loc.getStartLine())).append(this.separator);
                if (this.lineCountPerFile) {
                    writer.append(String.valueOf(loc.getLineCount())).append(this.separator);
                }
                writer.append(StringEscapeUtils.escapeCsv((String)report.getDisplayName(loc.getFileId())));
                if (!marks.hasNext()) continue;
                writer.append(this.separator);
            }
            writer.append(System.lineSeparator());
        }
        writer.flush();
    }

    @Override
    public void render(Iterator<Match> matches, Writer writer) throws IOException {
        RendererHelper.render(matches, writer, this);
    }
}

