/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.RendererHelper;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.util.StringUtil;

public class SimpleRenderer
implements CPDReportRenderer,
CPDRenderer {
    private String separator;
    private boolean trimLeadingWhitespace;
    public static final String DEFAULT_SEPARATOR = "=====================================================================";

    public SimpleRenderer() {
        this(false);
    }

    public SimpleRenderer(boolean trimLeadingWhitespace) {
        this(DEFAULT_SEPARATOR);
        this.trimLeadingWhitespace = trimLeadingWhitespace;
    }

    public SimpleRenderer(String theSeparator) {
        this.separator = theSeparator;
    }

    public void render(CPDReport report, Writer writer0) throws IOException {
        PrintWriter writer = new PrintWriter(writer0);
        Iterator matches = report.getMatches().iterator();
        if (matches.hasNext()) {
            this.renderOn(report, writer, (Match)matches.next());
        }
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            writer.println(this.separator);
            this.renderOn(report, writer, match);
        }
        writer.flush();
    }

    private void renderOn(CPDReport report, PrintWriter writer, Match match) throws IOException {
        writer.append("Found a ").append(String.valueOf(match.getLineCount())).append(" line (").append(String.valueOf(match.getTokenCount())).append(" tokens) duplication in the following files: ").println();
        for (Mark mark : match) {
            FileLocation loc = mark.getLocation();
            writer.append("Starting at line ").append(String.valueOf(loc.getStartLine())).append(" of ").append(report.getDisplayName(loc.getFileId())).println();
        }
        writer.println();
        Chars source = report.getSourceCodeSlice(match.getFirstMark());
        if (this.trimLeadingWhitespace) {
            for (Chars line : StringUtil.linesWithTrimIndent((Chars)source)) {
                line.writeFully((Writer)writer);
                writer.println();
            }
            return;
        }
        source.writeFully((Writer)writer);
        writer.println();
    }

    @Override
    public void render(Iterator<Match> matches, Writer writer) throws IOException {
        RendererHelper.render(matches, writer, this);
    }
}

