/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.function.Predicate;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.reporting.ViolationSuppressor;

public class Report
extends net.sourceforge.pmd.Report {
    @Override
    public Report filterViolations(Predicate<RuleViolation> filter) {
        Report copy = new Report();
        for (RuleViolation violation : this.violations) {
            if (!filter.test(violation)) continue;
            copy.addRuleViolation(violation);
        }
        copy.suppressedRuleViolations.addAll(this.suppressedRuleViolations);
        copy.errors.addAll(this.errors);
        copy.configErrors.addAll(this.configErrors);
        return copy;
    }

    public static final class ReportBuilderListener
    extends Report.ReportBuilderListener {
    }

    public static final class GlobalReportBuilderListener
    extends Report.GlobalReportBuilderListener {
    }

    public static class SuppressedViolation
    extends Report.SuppressedViolation {
        private final net.sourceforge.pmd.reporting.RuleViolation rv;

        public SuppressedViolation(net.sourceforge.pmd.reporting.RuleViolation rv, ViolationSuppressor suppressor, String userMessage) {
            super(rv, suppressor, userMessage);
            this.rv = rv;
        }

        @Override
        public net.sourceforge.pmd.reporting.RuleViolation getRuleViolation() {
            return this.rv;
        }
    }

    public static class ProcessingError
    extends Report.ProcessingError {
        public ProcessingError(Throwable error, FileId file) {
            super(error, file);
        }
    }

    public static class ConfigurationError
    extends Report.ConfigurationError {
        public ConfigurationError(Rule theRule, String theIssue) {
            super(theRule, theIssue);
        }

        @Override
        public net.sourceforge.pmd.lang.rule.Rule rule() {
            return (net.sourceforge.pmd.lang.rule.Rule)super.rule();
        }
    }
}

