/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Properties;
import java.util.regex.Pattern;
import net.sourceforge.pmd.cpd.CppBlockSkipper;
import net.sourceforge.pmd.cpd.CppEscapeTranslator;
import net.sourceforge.pmd.cpd.impl.JavaCCTokenizer;
import net.sourceforge.pmd.cpd.token.JavaCCTokenFilter;
import net.sourceforge.pmd.cpd.token.TokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.cpp.ast.CppTokenKinds;
import net.sourceforge.pmd.lang.document.TextDocument;

public class CPPTokenizer
extends JavaCCTokenizer {
    private boolean skipBlocks;
    private Pattern skipBlocksStart;
    private Pattern skipBlocksEnd;
    private boolean ignoreIdentifierAndLiteralSeqences = false;
    private boolean ignoreLiteralSequences = false;

    public CPPTokenizer() {
        this.setProperties(new Properties());
    }

    public void setProperties(Properties properties) {
        this.skipBlocks = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocks", Boolean.TRUE.toString()));
        if (this.skipBlocks) {
            String skipBlocksPattern = properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocksPattern", "#if 0|#endif");
            String[] split = skipBlocksPattern.split("\\|", 2);
            this.skipBlocksStart = CppBlockSkipper.compileSkipMarker(split[0]);
            this.skipBlocksEnd = split.length == 1 ? this.skipBlocksStart : CppBlockSkipper.compileSkipMarker(split[1]);
        }
        this.ignoreLiteralSequences = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipLiteralSequences", Boolean.FALSE.toString()));
        this.ignoreIdentifierAndLiteralSeqences = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipSequences", Boolean.FALSE.toString()));
    }

    protected JavaccTokenDocument.TokenDocumentBehavior tokenBehavior() {
        return new JavaccTokenDocument.TokenDocumentBehavior(CppTokenKinds.TOKEN_NAMES){

            public TextDocument translate(TextDocument text) throws MalformedSourceException {
                if (CPPTokenizer.this.skipBlocks) {
                    text = new CppBlockSkipper(text, CPPTokenizer.this.skipBlocksStart, CPPTokenizer.this.skipBlocksEnd).translateDocument();
                }
                return new CppEscapeTranslator(text).translateDocument();
            }
        };
    }

    protected TokenManager<JavaccToken> makeLexerImpl(CharStream sourceCode) {
        return CppTokenKinds.newTokenManager(sourceCode);
    }

    protected TokenFilter<JavaccToken> getTokenFilter(TokenManager<JavaccToken> tokenManager) {
        return new CppTokenFilter(tokenManager, this.ignoreLiteralSequences, this.ignoreIdentifierAndLiteralSeqences);
    }

    private static class CppTokenFilter
    extends JavaCCTokenFilter {
        private final boolean ignoreLiteralSequences;
        private final boolean ignoreIdentifierAndLiteralSeqences;
        private JavaccToken discardingTokensUntil = null;
        private boolean discardCurrent = false;

        CppTokenFilter(TokenManager<JavaccToken> tokenManager, boolean ignoreLiteralSequences, boolean ignoreIdentifierAndLiteralSeqences) {
            super(tokenManager);
            this.ignoreIdentifierAndLiteralSeqences = ignoreIdentifierAndLiteralSeqences;
            this.ignoreLiteralSequences = ignoreLiteralSequences;
        }

        protected void analyzeTokens(JavaccToken currentToken, Iterable<JavaccToken> remainingTokens) {
            this.discardCurrent = false;
            this.skipSequences(currentToken, remainingTokens);
        }

        private void skipSequences(JavaccToken currentToken, Iterable<JavaccToken> remainingTokens) {
            if (this.ignoreLiteralSequences || this.ignoreIdentifierAndLiteralSeqences) {
                int kind = currentToken.getKind();
                if (this.isDiscardingToken()) {
                    if (currentToken == this.discardingTokensUntil) {
                        this.discardingTokensUntil = null;
                        this.discardCurrent = true;
                    }
                } else if (kind == 17) {
                    JavaccToken finalToken;
                    this.discardingTokensUntil = finalToken = CppTokenFilter.findEndOfSequenceToDiscard(remainingTokens, this.ignoreIdentifierAndLiteralSeqences);
                }
            }
        }

        private static JavaccToken findEndOfSequenceToDiscard(Iterable<JavaccToken> remainingTokens, boolean ignoreIdentifierAndLiteralSeqences) {
            boolean seenAllowedToken = false;
            int braceCount = 0;
            block7: for (JavaccToken token : remainingTokens) {
                switch (token.getKind()) {
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 130: 
                    case 134: {
                        seenAllowedToken = true;
                        continue block7;
                    }
                    case 136: {
                        if (ignoreIdentifierAndLiteralSeqences) {
                            seenAllowedToken = true;
                            continue block7;
                        }
                        return null;
                    }
                    case 26: {
                        continue block7;
                    }
                    case 17: {
                        ++braceCount;
                        continue block7;
                    }
                    case 18: {
                        if (--braceCount >= 0) continue block7;
                        return seenAllowedToken ? token : null;
                    }
                }
                return null;
            }
            return null;
        }

        private boolean isDiscardingToken() {
            return this.discardingTokensUntil != null;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.isDiscardingToken() || this.discardCurrent;
        }
    }
}

