/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.cpp.cpd;

import java.util.regex.Pattern;
import net.sourceforge.pmd.cpd.CpdLanguageProperties;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.cpd.impl.JavaCCTokenFilter;
import net.sourceforge.pmd.cpd.impl.JavaccCpdLexer;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.cpp.CppLanguageModule;
import net.sourceforge.pmd.lang.cpp.ast.CppTokenKinds;
import net.sourceforge.pmd.lang.cpp.cpd.CppBlockSkipper;
import net.sourceforge.pmd.lang.cpp.cpd.CppEscapeTranslator;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.apache.commons.lang3.StringUtils;

public class CppCpdLexer
extends JavaccCpdLexer {
    private boolean skipBlocks;
    private Pattern skipBlocksStart;
    private Pattern skipBlocksEnd;
    private final boolean ignoreIdentifierAndLiteralSeqences;
    private final boolean ignoreLiteralSequences;
    private final boolean ignoreLiterals;
    private final boolean ignoreIdentifiers;

    public CppCpdLexer(LanguagePropertyBundle cppProperties) {
        this.ignoreLiteralSequences = (Boolean)cppProperties.getProperty(CpdLanguageProperties.CPD_IGNORE_LITERAL_SEQUENCES);
        this.ignoreIdentifierAndLiteralSeqences = (Boolean)cppProperties.getProperty(CpdLanguageProperties.CPD_IGNORE_LITERAL_AND_IDENTIFIER_SEQUENCES);
        this.ignoreLiterals = (Boolean)cppProperties.getProperty(CpdLanguageProperties.CPD_ANONYMIZE_LITERALS);
        this.ignoreIdentifiers = (Boolean)cppProperties.getProperty(CpdLanguageProperties.CPD_ANONYMIZE_IDENTIFIERS);
        String skipBlocksPattern = (String)cppProperties.getProperty(CppLanguageModule.CPD_SKIP_BLOCKS);
        if (StringUtils.isNotBlank((CharSequence)skipBlocksPattern)) {
            this.skipBlocks = true;
            String[] split = skipBlocksPattern.split("\\|", 2);
            this.skipBlocksStart = CppBlockSkipper.compileSkipMarker(split[0]);
            this.skipBlocksEnd = split.length == 1 ? this.skipBlocksStart : CppBlockSkipper.compileSkipMarker(split[1]);
        }
    }

    protected TokenManager<JavaccToken> makeLexerImpl(TextDocument doc) {
        return CppTokenKinds.newTokenManager(this.newCharStream(doc));
    }

    CharStream newCharStream(TextDocument doc) {
        return CharStream.create((TextDocument)doc, (JavaccTokenDocument.TokenDocumentBehavior)new JavaccTokenDocument.TokenDocumentBehavior(CppTokenKinds.TOKEN_NAMES){

            public TextDocument translate(TextDocument text) throws MalformedSourceException {
                if (CppCpdLexer.this.skipBlocks) {
                    text = new CppBlockSkipper(text, CppCpdLexer.this.skipBlocksStart, CppCpdLexer.this.skipBlocksEnd).translateDocument();
                }
                return new CppEscapeTranslator(text).translateDocument();
            }
        });
    }

    protected TokenManager<JavaccToken> filterTokenStream(TokenManager<JavaccToken> tokenManager) {
        return new CppTokenFilter(tokenManager, this.ignoreLiteralSequences, this.ignoreIdentifierAndLiteralSeqences);
    }

    protected void processToken(TokenFactory tokenEntries, JavaccToken currentToken) {
        boolean isLiteral;
        int kind = currentToken.getKind();
        String image = currentToken.getImage();
        boolean bl = isLiteral = kind == 134 || kind == 135 || kind == 132 || kind == 126 || kind == 127 || kind == 125 || kind == 130 || kind == 124 || kind == 123;
        if (this.ignoreLiterals && isLiteral) {
            image = CppTokenKinds.describe(kind);
        }
        if (this.ignoreIdentifiers && kind == 136) {
            image = CppTokenKinds.describe(kind);
        }
        tokenEntries.recordToken(image, currentToken.getReportLocation());
    }

    private static class CppTokenFilter
    extends JavaCCTokenFilter {
        private final boolean ignoreLiteralSequences;
        private final boolean ignoreIdentifierAndLiteralSeqences;
        private JavaccToken discardingTokensUntil = null;
        private boolean discardCurrent = false;

        CppTokenFilter(TokenManager<JavaccToken> tokenManager, boolean ignoreLiteralSequences, boolean ignoreIdentifierAndLiteralSeqences) {
            super(tokenManager);
            this.ignoreIdentifierAndLiteralSeqences = ignoreIdentifierAndLiteralSeqences;
            this.ignoreLiteralSequences = ignoreLiteralSequences;
        }

        protected void analyzeTokens(JavaccToken currentToken, Iterable<JavaccToken> remainingTokens) {
            this.discardCurrent = false;
            this.skipSequences(currentToken, remainingTokens);
        }

        private void skipSequences(JavaccToken currentToken, Iterable<JavaccToken> remainingTokens) {
            if (this.ignoreLiteralSequences || this.ignoreIdentifierAndLiteralSeqences) {
                int kind = currentToken.getKind();
                if (this.isDiscardingToken()) {
                    if (currentToken == this.discardingTokensUntil) {
                        this.discardingTokensUntil = null;
                        this.discardCurrent = true;
                    }
                } else if (kind == 17) {
                    this.discardingTokensUntil = CppTokenFilter.findEndOfSequenceToDiscard(remainingTokens, this.ignoreIdentifierAndLiteralSeqences);
                }
            }
        }

        private static JavaccToken findEndOfSequenceToDiscard(Iterable<JavaccToken> remainingTokens, boolean ignoreIdentifierAndLiteralSeqences) {
            boolean seenAllowedToken = false;
            int braceCount = 0;
            block7: for (JavaccToken token : remainingTokens) {
                switch (token.getKind()) {
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 130: 
                    case 134: {
                        seenAllowedToken = true;
                        continue block7;
                    }
                    case 136: {
                        if (ignoreIdentifierAndLiteralSeqences) {
                            seenAllowedToken = true;
                            continue block7;
                        }
                        return null;
                    }
                    case 26: {
                        continue block7;
                    }
                    case 17: {
                        ++braceCount;
                        continue block7;
                    }
                    case 18: {
                        if (--braceCount >= 0) continue block7;
                        return seenAllowedToken ? token : null;
                    }
                }
                return null;
            }
            return null;
        }

        private boolean isDiscardingToken() {
            return this.discardingTokensUntil != null;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.isDiscardingToken() || this.discardCurrent;
        }
    }
}

