/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.AntlrTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.token.AntlrToken;
import net.sourceforge.pmd.cpd.token.AntlrTokenFilter;
import net.sourceforge.pmd.lang.antlr.AntlrTokenManager;
import net.sourceforge.pmd.lang.dart.antlr4.Dart2Lexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;

public class DartTokenizer
extends AntlrTokenizer {
    protected AntlrTokenManager getLexerForSource(SourceCode sourceCode) {
        CharStream charStream = AntlrTokenizer.getCharStreamFromSourceCode((SourceCode)sourceCode);
        return new AntlrTokenManager((Lexer)new Dart2Lexer(charStream), sourceCode.getFileName());
    }

    protected AntlrTokenFilter getTokenFilter(AntlrTokenManager tokenManager) {
        return new DartTokenFilter(tokenManager);
    }

    private static class DartTokenFilter
    extends AntlrTokenFilter {
        private boolean discardingLibraryAndImport = false;
        private boolean discardingNL = false;
        private boolean discardingSemicolon = false;

        DartTokenFilter(AntlrTokenManager tokenManager) {
            super(tokenManager);
        }

        protected void analyzeToken(AntlrToken currentToken) {
            this.skipLibraryAndImport(currentToken);
            this.skipNewLines(currentToken);
            this.skipSemicolons(currentToken);
        }

        private void skipLibraryAndImport(AntlrToken currentToken) {
            int type = currentToken.getType();
            if (type == 121 || type == 119) {
                this.discardingLibraryAndImport = true;
            } else if (this.discardingLibraryAndImport && (type == 103 || type == 107)) {
                this.discardingLibraryAndImport = false;
            }
        }

        private void skipNewLines(AntlrToken currentToken) {
            this.discardingNL = currentToken.getType() == 107;
        }

        private void skipSemicolons(AntlrToken currentToken) {
            this.discardingSemicolon = currentToken.getType() == 103;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingLibraryAndImport || this.discardingNL || this.discardingSemicolon;
        }
    }
}

