/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.doc.internal;

import java.io.File;
import java.util.regex.Pattern;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class RuleSetUtils {
    private RuleSetUtils() {
    }

    public static String getRuleSetFilename(RuleSet ruleset) {
        return RuleSetUtils.getRuleSetFilename(ruleset.getFileName());
    }

    public static String getRuleSetFilename(String rulesetFileName) {
        return IOUtil.getFilenameBase((String)StringUtils.chomp((String)rulesetFileName));
    }

    public static boolean isRuleSetDeprecated(RuleSet ruleset) {
        boolean result = true;
        for (Rule rule : ruleset.getRules()) {
            if (rule instanceof RuleReference && rule.isDeprecated()) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String getRuleSetClasspath(RuleSet ruleset) {
        String RESOURCES_PATH = "/resources/";
        String filename = RuleSetUtils.normalizeForwardSlashes(StringUtils.chomp((String)ruleset.getFileName()));
        int startIndex = filename.lastIndexOf("/resources/");
        if (startIndex > -1) {
            return filename.substring(startIndex + "/resources/".length());
        }
        return filename;
    }

    public static String normalizeForwardSlashes(String path) {
        String normalized = IOUtil.normalizePath((String)path);
        if (SystemUtils.IS_OS_WINDOWS) {
            normalized = normalized.replaceAll(Pattern.quote(File.separator), "/");
        }
        return normalized;
    }

    public static Rule resolveRuleReferences(Rule rule) {
        Rule result = rule;
        Rule ref = rule;
        while (ref instanceof RuleReference) {
            result = ref;
            ref = ((RuleReference)ref).getRule();
        }
        return result;
    }
}

