/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.html.ast;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlCDataNode;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlComment;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlDocument;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlDocumentType;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlElement;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlTextNode;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlXmlDeclaration;
import net.sourceforge.pmd.lang.html.ast.AbstractHtmlNode;

class LineNumbers {
    private final ASTHtmlDocument document;
    private final Chars htmlString;

    LineNumbers(ASTHtmlDocument document) {
        this.document = document;
        this.htmlString = document.getTextDocument().getText();
    }

    public void determine() {
        this.determineLocation(this.document, 0);
    }

    private int determineLocation(AbstractHtmlNode<?> n, int index) {
        boolean isAutoClose;
        int nextIndex = index;
        int nodeLength = 0;
        int textLength = 0;
        if (n instanceof ASTHtmlDocument) {
            nextIndex = index;
        } else if (n instanceof ASTHtmlComment) {
            nextIndex = this.htmlString.indexOf("<!--", nextIndex);
        } else if (n instanceof ASTHtmlElement) {
            nextIndex = this.htmlString.indexOf("<" + n.getXPathNodeName(), nextIndex);
            nodeLength = this.htmlString.indexOf(">", nextIndex) - nextIndex + 1;
        } else if (n instanceof ASTHtmlCDataNode) {
            nextIndex = this.htmlString.indexOf("<![CDATA[", nextIndex);
        } else if (n instanceof ASTHtmlXmlDeclaration) {
            nextIndex = this.htmlString.indexOf("<?", nextIndex);
        } else if (n instanceof ASTHtmlTextNode) {
            textLength = ((ASTHtmlTextNode)n).getText().length();
        } else if (n instanceof ASTHtmlDocumentType) {
            nextIndex = index;
        }
        this.setBeginLocation(n, nextIndex);
        nextIndex += nodeLength;
        for (Node child : n.children()) {
            nextIndex = this.determineLocation((AbstractHtmlNode)child, nextIndex);
        }
        boolean bl = isAutoClose = n.getNumChildren() == 0 && n instanceof ASTHtmlElement && this.htmlString.startsWith("/>", nextIndex - 2);
        if (n instanceof ASTHtmlDocument) {
            nextIndex = this.htmlString.length();
        } else if (n instanceof ASTHtmlElement && !isAutoClose) {
            nextIndex += 2 + n.getXPathNodeName().length() + 1;
        } else if (n instanceof ASTHtmlComment) {
            nextIndex += 7;
            nextIndex += ((ASTHtmlComment)n).getData().length();
        } else if (n instanceof ASTHtmlTextNode) {
            nextIndex += textLength;
        } else if (n instanceof ASTHtmlCDataNode) {
            nextIndex += "<![CDATA[".length() + ((ASTHtmlCDataNode)n).getText().length() + "]]>".length();
        } else if (n instanceof ASTHtmlXmlDeclaration) {
            nextIndex = this.htmlString.indexOf("?>", nextIndex) + 2;
        } else if (n instanceof ASTHtmlDocumentType) {
            nextIndex = this.htmlString.indexOf(">", nextIndex) + 1;
        }
        this.setEndLocation(n, nextIndex - 1);
        return nextIndex;
    }

    private void setBeginLocation(AbstractHtmlNode<?> n, int index) {
        if (n != null) {
            n.startOffset = index;
        }
    }

    private void setEndLocation(AbstractHtmlNode<?> n, int index) {
        if (n != null) {
            n.endOffset = index;
        }
    }
}

