/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.html.ast;

import java.util.Map;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlCDataNode;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlComment;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlDocument;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlDocumentType;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlElement;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlTextNode;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlXmlDeclaration;
import net.sourceforge.pmd.lang.html.ast.AbstractHtmlNode;
import net.sourceforge.pmd.lang.html.ast.LineNumbers;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;

final class HtmlTreeBuilder {
    HtmlTreeBuilder() {
    }

    public ASTHtmlDocument build(Document doc, Parser.ParserTask task, Map<Integer, String> suppressMap) {
        ASTHtmlDocument root = new ASTHtmlDocument(doc, task, suppressMap);
        this.addChildren(root, (Node)doc);
        LineNumbers lineNumbers = new LineNumbers(root);
        lineNumbers.determine();
        return root;
    }

    private void addChildren(AbstractHtmlNode<?> parent, Node node) {
        for (Node child : node.childNodes()) {
            AbstractHtmlNode<? extends Node> converted = this.convertJsoupNode(child);
            parent.addChild(converted, parent.getNumChildren());
            this.addChildren(converted, child);
        }
    }

    private AbstractHtmlNode<? extends Node> convertJsoupNode(Node node) {
        if (node instanceof Element) {
            return new ASTHtmlElement((Element)node);
        }
        if (node instanceof CDataNode) {
            return new ASTHtmlCDataNode((CDataNode)node);
        }
        if (node instanceof TextNode) {
            return new ASTHtmlTextNode((TextNode)node);
        }
        if (node instanceof Comment) {
            return new ASTHtmlComment((Comment)node);
        }
        if (node instanceof XmlDeclaration) {
            return new ASTHtmlXmlDeclaration((XmlDeclaration)node);
        }
        if (node instanceof DocumentType) {
            return new ASTHtmlDocumentType((DocumentType)node);
        }
        throw new RuntimeException("Unsupported node type: " + node.getClass());
    }
}

