/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.html.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.html.ast.AbstractHtmlNode;
import net.sourceforge.pmd.lang.html.ast.HtmlVisitor;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import org.jsoup.nodes.Element;

public class ASTHtmlElement
extends AbstractHtmlNode<Element> {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    ASTHtmlElement(Element element) {
        super(element);
        for (org.jsoup.nodes.Attribute att : ((Element)this.node).attributes()) {
            this.attributes.add(new Attribute((Node)this, att.getKey(), att.getValue()));
        }
    }

    @Override
    protected <P, R> R acceptHtmlVisitor(HtmlVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.stream().anyMatch(attribute -> name.equalsIgnoreCase(attribute.getName()));
    }

    public String getAttribute(String rel) {
        return this.attributes.stream().filter(attribute -> rel.equalsIgnoreCase(attribute.getName())).findFirst().map(Attribute::getValue).map(String::valueOf).orElse(null);
    }

    public Iterator<Attribute> getXPathAttributesIterator() {
        final Iterator defaultAttributes = super.getXPathAttributesIterator();
        final Iterator<Attribute> elementAttributes = this.attributes.iterator();
        return new Iterator<Attribute>(){

            @Override
            public boolean hasNext() {
                return defaultAttributes.hasNext() || elementAttributes.hasNext();
            }

            @Override
            public Attribute next() {
                if (defaultAttributes.hasNext()) {
                    return (Attribute)defaultAttributes.next();
                }
                return (Attribute)elementAttributes.next();
            }
        };
    }
}

