/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.NameFinder;
import net.sourceforge.pmd.lang.java.symboltable.Search;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class OccurrenceFinder
extends JavaParserVisitorAdapter {
    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        NameFinder nameFinder = new NameFinder(node);
        NameDeclaration decl = null;
        List<JavaNameOccurrence> names = nameFinder.getNames();
        for (JavaNameOccurrence occ : names) {
            Search search = new Search(occ);
            if (decl == null) {
                search.execute();
                decl = search.getResult();
                if (decl != null) continue;
                break;
            }
            Scope startingScope = decl.getScope();
            if (decl instanceof VariableNameDeclaration) {
                String typeImage = ((VariableNameDeclaration)decl).getTypeImage();
                ClassNameDeclaration clazzDeclaration = ((SourceFileScope)startingScope.getEnclosingScope(SourceFileScope.class)).findClassNameDeclaration(typeImage);
                if (clazzDeclaration != null) {
                    startingScope = clazzDeclaration.getScope();
                }
            }
            search.execute(startingScope);
            decl = search.getResult();
            if (decl != null) continue;
            break;
        }
        return super.visit(node, data);
    }
}

