/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.optimizations;

import java.math.BigInteger;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class RedundantFieldInitializerRule
extends AbstractJavaRule {
    public RedundantFieldInitializerRule() {
        this.addRuleChainVisit(ASTFieldDeclaration.class);
    }

    @Override
    public Object visit(ASTFieldDeclaration fieldDeclaration, Object data) {
        if (fieldDeclaration.isFinal()) {
            return data;
        }
        for (ASTVariableDeclarator variableDeclarator : fieldDeclaration.findChildrenOfType(ASTVariableDeclarator.class)) {
            String s;
            Node primaryPrefix;
            Node primaryExpression;
            Node expression;
            Node variableInitializer;
            if (variableDeclarator.jjtGetNumChildren() <= 1 || !((variableInitializer = variableDeclarator.jjtGetChild(1)).jjtGetChild(0) instanceof ASTExpression) || (expression = variableInitializer.jjtGetChild(0)).jjtGetNumChildren() != 1) continue;
            if (expression.jjtGetChild(0) instanceof ASTPrimaryExpression) {
                primaryExpression = expression.jjtGetChild(0);
            } else {
                if (!(expression.jjtGetChild(0) instanceof ASTCastExpression) || !(expression.jjtGetChild(0).jjtGetChild(1) instanceof ASTPrimaryExpression)) continue;
                primaryExpression = expression.jjtGetChild(0).jjtGetChild(1);
            }
            if ((primaryPrefix = primaryExpression.jjtGetChild(0)).jjtGetNumChildren() != 1 || !(primaryPrefix.jjtGetChild(0) instanceof ASTLiteral)) continue;
            ASTLiteral literal = (ASTLiteral)primaryPrefix.jjtGetChild(0);
            if (this.isRef(fieldDeclaration, variableDeclarator)) {
                if (literal.jjtGetNumChildren() != 1 || !(literal.jjtGetChild(0) instanceof ASTNullLiteral)) continue;
                this.addViolation(data, variableDeclarator);
                continue;
            }
            if (literal.jjtGetNumChildren() == 1 && literal.jjtGetChild(0) instanceof ASTBooleanLiteral) {
                ASTBooleanLiteral booleanLiteral = (ASTBooleanLiteral)literal.jjtGetChild(0);
                if (booleanLiteral.isTrue()) continue;
                this.addViolation(data, variableDeclarator);
                continue;
            }
            if (literal.jjtGetNumChildren() != 0) continue;
            Number value = -1;
            if (literal.isIntLiteral()) {
                value = this.parseInteger(literal.getImage());
            } else if (literal.isLongLiteral()) {
                s = literal.getImage();
                s = s.substring(0, s.length() - 1);
                value = this.parseInteger(s);
            } else if (literal.isFloatLiteral()) {
                s = literal.getImage();
                s = s.substring(0, s.length() - 1);
                value = Float.valueOf(s);
            } else if (literal.isDoubleLiteral()) {
                value = Double.valueOf(literal.getImage());
            } else if (literal.isCharLiteral()) {
                value = (int)literal.getImage().charAt(1);
            }
            if (value.intValue() != 0) continue;
            this.addViolation(data, variableDeclarator);
        }
        return data;
    }

    private boolean isRef(ASTFieldDeclaration fieldDeclaration, ASTVariableDeclarator variableDeclarator) {
        Node type = fieldDeclaration.jjtGetChild(0).jjtGetChild(0);
        if (type instanceof ASTReferenceType) {
            return true;
        }
        return ((ASTVariableDeclaratorId)variableDeclarator.jjtGetChild(0)).isArray();
    }

    private void addViolation(Object data, ASTVariableDeclarator variableDeclarator) {
        super.addViolation(data, (Node)variableDeclarator, variableDeclarator.jjtGetChild(0).getImage());
    }

    private Number parseInteger(String s) {
        boolean negative = false;
        String number = s;
        if (number.charAt(0) == '-') {
            negative = true;
            number = number.substring(1);
        }
        BigInteger result = number.startsWith("0x") || number.startsWith("0X") ? new BigInteger(number.substring(2).replaceAll("_", ""), 16) : (number.startsWith("0b") || number.startsWith("0B") ? new BigInteger(number.substring(2).replaceAll("_", ""), 8) : (number.charAt(0) == '0' && number.length() > 1 ? new BigInteger(number.substring(1).replaceAll("_", ""), 8) : new BigInteger(number.replaceAll("_", ""))));
        if (negative) {
            result = result.negate();
        }
        return result;
    }
}

