/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.NameFinder;
import net.sourceforge.pmd.lang.java.symboltable.Search;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class OccurrenceFinder
extends JavaParserVisitorAdapter {
    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        NameFinder nameFinder = new NameFinder(node);
        HashSet<Object> declarations = new HashSet<Object>();
        List<JavaNameOccurrence> names = nameFinder.getNames();
        for (JavaNameOccurrence occ : names) {
            Search search = new Search(occ);
            if (declarations.isEmpty()) {
                search.execute();
                declarations.addAll(search.getResult());
                if (!declarations.isEmpty()) continue;
                break;
            }
            HashSet<NameDeclaration> additionalDeclarations = new HashSet<NameDeclaration>();
            for (NameDeclaration nameDeclaration : declarations) {
                Scope startingScope = nameDeclaration.getScope();
                if (nameDeclaration instanceof VariableNameDeclaration) {
                    String typeImage = ((VariableNameDeclaration)nameDeclaration).getTypeImage();
                    ClassNameDeclaration clazzDeclaration = ((SourceFileScope)startingScope.getEnclosingScope(SourceFileScope.class)).findClassNameDeclaration(typeImage);
                    if (clazzDeclaration != null) {
                        startingScope = clazzDeclaration.getScope();
                    }
                }
                search.execute(startingScope);
                Set<NameDeclaration> result = search.getResult();
                additionalDeclarations.addAll(result);
                if (!result.isEmpty()) continue;
                break;
            }
            declarations.addAll(additionalDeclarations);
        }
        return super.visit(node, data);
    }
}

