/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class CloneMethodMustImplementCloneable
extends AbstractJavaRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (this.extendsOrImplementsCloneable(node)) {
            return data;
        }
        return super.visit(node, data);
    }

    private boolean extendsOrImplementsCloneable(ASTClassOrInterfaceDeclaration node) {
        ASTImplementsList impl = (ASTImplementsList)node.getFirstChildOfType(ASTImplementsList.class);
        if (impl != null && impl.jjtGetParent().equals(node)) {
            for (int ix = 0; ix < impl.jjtGetNumChildren(); ++ix) {
                Node child = impl.jjtGetChild(ix);
                if (child.getClass() != ASTClassOrInterfaceType.class) continue;
                ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)child;
                if (type.getType() == null) {
                    if (!"Cloneable".equals(type.getImage())) continue;
                    return true;
                }
                if (type.getType().equals(Cloneable.class)) {
                    return true;
                }
                if (Cloneable.class.isAssignableFrom(type.getType())) {
                    return true;
                }
                List<Class<?>> implementors = Arrays.asList(type.getType().getInterfaces());
                if (!implementors.contains(Cloneable.class)) continue;
                return true;
            }
        }
        if (node.jjtGetNumChildren() != 0 && node.jjtGetChild(0) instanceof ASTExtendsList) {
            ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)node.jjtGetChild(0).jjtGetChild(0);
            Class<?> clazz = type.getType();
            if (clazz != null && clazz.equals(Cloneable.class)) {
                return true;
            }
            while (clazz != null && !Object.class.equals(clazz)) {
                if (Arrays.asList(clazz.getInterfaces()).contains(Cloneable.class)) {
                    return true;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        List blocks;
        ASTClassOrInterfaceDeclaration classOrInterface = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (classOrInterface != null && (node.isFinal() || classOrInterface.isFinal()) && node.findDescendantsOfType(ASTBlock.class).size() == 1 && (blocks = node.findDescendantsOfType(ASTBlockStatement.class)).size() == 1) {
            ASTBlockStatement block = (ASTBlockStatement)blocks.get(0);
            ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)block.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (type != null && type.getType() != null && type.getNthParent(9).equals(node) && type.getType().equals(CloneNotSupportedException.class)) {
                return data;
            }
            if (type != null && type.getType() == null && "CloneNotSupportedException".equals(type.getImage())) {
                return data;
            }
        }
        if (classOrInterface != null) {
            ASTClassOrInterfaceType type;
            ASTExtendsList extendsList;
            Set<String> classesNames = this.determineTopLevelCloneableClasses(classOrInterface);
            ASTImplementsList implementsList = (ASTImplementsList)classOrInterface.getFirstChildOfType(ASTImplementsList.class);
            if (implementsList != null) {
                List types = implementsList.findChildrenOfType(ASTClassOrInterfaceType.class);
                for (ASTClassOrInterfaceType t : types) {
                    if (!classesNames.contains(t.getImage())) continue;
                    return data;
                }
            }
            if ((extendsList = (ASTExtendsList)classOrInterface.getFirstChildOfType(ASTExtendsList.class)) != null && classesNames.contains((type = (ASTClassOrInterfaceType)extendsList.getFirstChildOfType(ASTClassOrInterfaceType.class)).getImage())) {
                return data;
            }
        }
        return super.visit(node, data);
    }

    private Set<String> determineTopLevelCloneableClasses(ASTClassOrInterfaceDeclaration currentClass) {
        List classes = ((ASTCompilationUnit)currentClass.getFirstParentOfType(ASTCompilationUnit.class)).findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        HashSet<String> classesNames = new HashSet<String>();
        for (ASTClassOrInterfaceDeclaration c : classes) {
            if (c == currentClass || !this.extendsOrImplementsCloneable(c)) continue;
            classesNames.add(c.getImage());
        }
        return classesNames;
    }

    @Override
    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!"clone".equals(node.getImage())) {
            return data;
        }
        int countParams = ((ASTFormalParameters)node.jjtGetChild(0)).jjtGetNumChildren();
        if (countParams != 0) {
            return data;
        }
        this.addViolation(data, (Node)node);
        return data;
    }
}

