/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.imports;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.DummyJavaNode;
import net.sourceforge.pmd.lang.java.ast.FormalComment;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.ImportWrapper;

public class UnusedImportsRule
extends AbstractJavaRule {
    protected Set<ImportWrapper> imports = new HashSet<ImportWrapper>();
    private static final Pattern SEE_PATTERN = Pattern.compile("@see\\s+(\\p{Alpha}\\w*)(?:#\\w*(?:\\(([\\w\\s,]*)\\))?)?");
    private static final Pattern LINK_PATTERNS = Pattern.compile("\\{@link(?:plain)?\\s+(\\p{Alpha}\\w*)(?:#\\w*(?:\\(([.\\w\\s,]*)\\))?)?[\\s\\}]");
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\{@value\\s+(\\p{Alpha}\\w*)[\\s#\\}]");
    private static final Pattern THROWS_PATTERN = Pattern.compile("@throws\\s+(\\p{Alpha}\\w*)");
    private static final Pattern[] PATTERNS = new Pattern[]{SEE_PATTERN, LINK_PATTERNS, VALUE_PATTERN, THROWS_PATTERN};

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        super.visit(node, data);
        this.visitComments(node);
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0) instanceof ASTPackageDeclaration) {
            this.visit((ASTPackageDeclaration)node.jjtGetChild(0), data);
        }
        for (ImportWrapper wrapper : this.imports) {
            this.addViolation(data, wrapper.getNode(), wrapper.getFullName());
        }
        return data;
    }

    private void visitComments(ASTCompilationUnit node) {
        if (this.imports.isEmpty()) {
            return;
        }
        for (Comment comment : node.getComments()) {
            if (!(comment instanceof FormalComment)) continue;
            for (Pattern p : PATTERNS) {
                Matcher m = p.matcher(comment.getImage());
                while (m.find()) {
                    String s = m.group(1);
                    this.imports.remove(new ImportWrapper(s, s, (Node)new DummyJavaNode(-1)));
                    if (m.groupCount() > 1 && (s = m.group(2)) != null) {
                        String[] params;
                        for (String param : params = s.split("\\s*,\\s*")) {
                            this.imports.remove(new ImportWrapper(param, param, (Node)new DummyJavaNode(-1)));
                        }
                    }
                    if (!this.imports.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        if (!node.isImportOnDemand()) {
            String className;
            ASTName importedType = (ASTName)node.jjtGetChild(0);
            if (UnusedImportsRule.isQualifiedName(importedType)) {
                int lastDot = importedType.getImage().lastIndexOf(46) + 1;
                className = importedType.getImage().substring(lastDot);
            } else {
                className = importedType.getImage();
            }
            this.imports.add(new ImportWrapper(importedType.getImage(), className, (Node)node));
        }
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.check(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTName node, Object data) {
        this.check(node);
        return data;
    }

    protected void check(Node node) {
        if (this.imports.isEmpty()) {
            return;
        }
        ImportWrapper candidate = this.getImportWrapper(node);
        if (this.imports.contains(candidate)) {
            this.imports.remove(candidate);
        }
    }

    protected ImportWrapper getImportWrapper(Node node) {
        String name = !UnusedImportsRule.isQualifiedName(node) ? node.getImage() : node.getImage().substring(0, node.getImage().indexOf(46));
        ImportWrapper candidate = new ImportWrapper(node.getImage(), name);
        return candidate;
    }
}

