/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.logging;

import java.util.List;
import java.util.logging.Level;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.rule.logging.GuardLogStatementRule;

public class GuardLogStatementJavaUtilRule
extends GuardLogStatementRule {
    private static final String GUARD_METHOD_NAME = "isLoggable";
    private static String extendedXPath = "//PrimaryPrefix[ends-with(Name/@Image, '.log')]\n[following-sibling::PrimarySuffix\n    [ends-with(.//PrimaryPrefix/Name/@Image, 'LOG_LEVEL_UPPERCASE')]\n    [count(../descendant::AdditiveExpression) > 0]\n]\n[count(ancestor::IfStatement/Expression/descendant::PrimaryExpression\n    [ends-with(descendant::PrimaryPrefix[1]/Name/@Image,'GUARD')]) = 0\nor\ncount(ancestor::IfStatement/Expression/descendant::PrimaryExpression\n    [ends-with(descendant::PrimaryPrefix[2]/Name/@Image,'LOG_LEVEL_UPPERCASE')]) = 0]";

    @Override
    public Object visit(ASTCompilationUnit unit, Object data) {
        if (this.isSlf4jOrLog4jImported(unit)) {
            return data;
        }
        String[] logLevels = (String[])this.getProperty((PropertyDescriptor)LOG_LEVELS);
        String[] guardMethods = (String[])this.getProperty((PropertyDescriptor)GUARD_METHODS);
        if (this.guardStmtByLogLevel.isEmpty() && logLevels.length > 0 && guardMethods.length > 0) {
            this.configureGuards(logLevels, guardMethods);
        } else if (this.guardStmtByLogLevel.isEmpty()) {
            this.configureDefaultGuards();
        }
        this.findViolationForEachLogStatement(unit, data, extendedXPath);
        return super.visit(unit, data);
    }

    private boolean isSlf4jOrLog4jImported(ASTCompilationUnit unit) {
        List imports = unit.findChildrenOfType(ASTImportDeclaration.class);
        for (ASTImportDeclaration i : imports) {
            if (!i.getImportedName().startsWith("org.slf4j") && !i.getImportedName().startsWith("org.apache.log4j")) continue;
            return true;
        }
        return false;
    }

    private void configureGuards(String[] logLevels, String[] guardMethods) {
        String[] methods = guardMethods;
        if (methods.length != logLevels.length) {
            String firstMethodName = guardMethods[0];
            methods = new String[logLevels.length];
            for (int i = 0; i < logLevels.length; ++i) {
                methods[i] = firstMethodName;
            }
        }
        for (int i = 0; i < logLevels.length; ++i) {
            this.guardStmtByLogLevel.put("." + logLevels[i], methods[i]);
        }
    }

    private void configureDefaultGuards() {
        this.guardStmtByLogLevel.put(this.formatLogLevelString(Level.FINEST), GUARD_METHOD_NAME);
        this.guardStmtByLogLevel.put(this.formatLogLevelString(Level.FINER), GUARD_METHOD_NAME);
        this.guardStmtByLogLevel.put(this.formatLogLevelString(Level.FINE), GUARD_METHOD_NAME);
        this.guardStmtByLogLevel.put(this.formatLogLevelString(Level.INFO), GUARD_METHOD_NAME);
        this.guardStmtByLogLevel.put(this.formatLogLevelString(Level.WARNING), GUARD_METHOD_NAME);
        this.guardStmtByLogLevel.put(this.formatLogLevelString(Level.SEVERE), GUARD_METHOD_NAME);
    }

    private String formatLogLevelString(Level logLevel) {
        return "." + logLevel.toString().toLowerCase();
    }
}

