/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.typeresolution.visitors.PMDASMVisitor;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class PMDASMClassLoader
extends ClassLoader {
    private static PMDASMClassLoader cachedPMDASMClassLoader;
    private static ClassLoader cachedClassLoader;
    private final Set<String> dontBother = new HashSet<String>();

    public static synchronized PMDASMClassLoader getInstance(ClassLoader parent) {
        if (parent.equals(cachedClassLoader)) {
            return cachedPMDASMClassLoader;
        }
        cachedClassLoader = parent;
        cachedPMDASMClassLoader = new PMDASMClassLoader(parent);
        return cachedPMDASMClassLoader;
    }

    private PMDASMClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.dontBother.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            this.dontBother.add(name);
            throw e;
        }
        catch (NoClassDefFoundError e) {
            this.dontBother.add(name);
            throw new ClassNotFoundException(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, String> getImportedClasses(String name) throws ClassNotFoundException {
        Map<String, String> map;
        if (this.dontBother.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        InputStream stream = null;
        try {
            stream = this.getResourceAsStream(name.replace('.', '/') + ".class");
            ClassReader reader = new ClassReader(stream);
            PMDASMVisitor asmVisitor = new PMDASMVisitor();
            reader.accept((ClassVisitor)asmVisitor, 0);
            List<String> inner = asmVisitor.getInnerClasses();
            if (inner != null && !inner.isEmpty()) {
                inner = new ArrayList<String>(inner);
                for (String str : inner) {
                    InputStream innerClassStream = null;
                    try {
                        innerClassStream = this.getResourceAsStream(str.replace('.', '/') + ".class");
                        reader = new ClassReader(innerClassStream);
                        reader.accept((ClassVisitor)asmVisitor, 0);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(innerClassStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)innerClassStream);
                }
            }
            map = asmVisitor.getPackages();
        }
        catch (IOException e) {
            try {
                this.dontBother.add(name);
                throw new ClassNotFoundException(name, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return map;
    }
}

