/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.sunsecure;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.rule.sunsecure.AbstractSunSecureRule;
import org.jaxen.JaxenException;

public class MethodReturnsInternalArrayRule
extends AbstractSunSecureRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        if (!method.getResultType().returnsArray() || method.isPrivate()) {
            return data;
        }
        List returns = method.findDescendantsOfType(ASTReturnStatement.class);
        ASTTypeDeclaration td = (ASTTypeDeclaration)method.getFirstParentOfType(ASTTypeDeclaration.class);
        for (ASTReturnStatement ret : returns) {
            ASTPrimarySuffix ps;
            String vn = this.getReturnedVariableName(ret);
            if (!this.isField(vn, td) || ret.findDescendantsOfType(ASTPrimarySuffix.class).size() > 2 || ret.hasDescendantOfType(ASTAllocationExpression.class) || this.hasArraysCopyOf(ret) || this.hasClone(ret, vn) || this.isEmptyArray(vn, td)) continue;
            if (!this.isLocalVariable(vn, method)) {
                this.addViolation(data, (Node)ret, vn);
                continue;
            }
            ASTPrimaryPrefix pp = (ASTPrimaryPrefix)ret.getFirstDescendantOfType(ASTPrimaryPrefix.class);
            if (pp == null || !pp.usesThisModifier() || !(ps = (ASTPrimarySuffix)ret.getFirstDescendantOfType(ASTPrimarySuffix.class)).hasImageEqualTo(vn)) continue;
            this.addViolation(data, (Node)ret, vn);
        }
        return data;
    }

    private boolean hasClone(ASTReturnStatement ret, String varName) {
        List expressions = ret.findDescendantsOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression e : expressions) {
            ASTName name;
            if (!(e.jjtGetChild(0) instanceof ASTPrimaryPrefix) || e.jjtGetNumChildren() != 2 || !(e.jjtGetChild(1) instanceof ASTPrimarySuffix) || !((ASTPrimarySuffix)e.jjtGetChild(1)).isArguments() || ((ASTPrimarySuffix)e.jjtGetChild(1)).getArgumentCount() != 0 || (name = (ASTName)e.getFirstDescendantOfType(ASTName.class)) == null || !name.hasImageEqualTo(varName + ".clone")) continue;
            return true;
        }
        return false;
    }

    private boolean hasArraysCopyOf(ASTReturnStatement ret) {
        List expressions = ret.findDescendantsOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression e : expressions) {
            if (e.jjtGetNumChildren() != 2 || !(e.jjtGetChild(0) instanceof ASTPrimaryPrefix) || e.jjtGetChild(0).jjtGetNumChildren() != 1 || !(e.jjtGetChild(0).jjtGetChild(0) instanceof ASTName) || !e.jjtGetChild(0).jjtGetChild(0).getImage().endsWith("Arrays.copyOf")) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyArray(String varName, ASTTypeDeclaration typeDeclaration) {
        List fds = typeDeclaration.findDescendantsOfType(ASTFieldDeclaration.class);
        if (fds != null) {
            for (ASTFieldDeclaration fd : fds) {
                ASTVariableInitializer initializer;
                ASTVariableDeclaratorId vid = (ASTVariableDeclaratorId)fd.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
                if (vid == null || !vid.hasImageEqualTo(varName) || (initializer = (ASTVariableInitializer)fd.getFirstDescendantOfType(ASTVariableInitializer.class)) == null || initializer.jjtGetNumChildren() != 1) continue;
                Node child = initializer.jjtGetChild(0);
                if (child instanceof ASTArrayInitializer && child.jjtGetNumChildren() == 0) {
                    return true;
                }
                if (!(child instanceof ASTExpression)) continue;
                try {
                    List arrayAllocation = child.findChildNodesWithXPath("./PrimaryExpression/PrimaryPrefix/AllocationExpression/ArrayDimsAndInits/Expression/PrimaryExpression/PrimaryPrefix/Literal[@IntLiteral=\"true\"][@Image=\"0\"]");
                    if (arrayAllocation == null || arrayAllocation.size() != 1) continue;
                    return true;
                }
                catch (JaxenException e) {
                    return false;
                }
            }
        }
        return false;
    }
}

