/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTType;

public final class QualifiedName {
    public static final Pattern FORMAT = Pattern.compile("((\\w+\\.)+|\\.)((\\w+)(\\$\\w+)*)(#(\\w+)\\(((\\w+)(, \\w+)*)?\\))?");
    private String[] packages = null;
    private String[] classes = new String[1];
    private String operation = null;

    private QualifiedName() {
    }

    public static QualifiedName makeOperationOf(ASTMethodDeclaration node) {
        QualifiedName parentQname = ((ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)).getQualifiedName();
        return QualifiedName.makeOperationOf(parentQname, node.getMethodName(), (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class));
    }

    public static QualifiedName makeOperationOf(ASTConstructorDeclaration node) {
        ASTClassOrInterfaceDeclaration parent = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        return QualifiedName.makeOperationOf(parent.getQualifiedName(), parent.getImage(), (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class));
    }

    private static QualifiedName makeOperationOf(QualifiedName parent, String opName, ASTFormalParameters params) {
        QualifiedName qname = new QualifiedName();
        qname.packages = parent.packages;
        qname.classes = parent.classes;
        qname.operation = QualifiedName.getOperationName(opName, params);
        return qname;
    }

    public static QualifiedName makeNestedClassOf(QualifiedName parent, String className) {
        QualifiedName qname = new QualifiedName();
        qname.packages = parent.packages;
        if (parent.classes[0] != null) {
            qname.classes = Arrays.copyOf(parent.classes, parent.classes.length + 1);
            qname.classes[parent.classes.length] = className;
        } else {
            qname.classes[0] = className;
        }
        return qname;
    }

    public static QualifiedName makeOuterClassOf(ASTClassOrInterfaceDeclaration node) {
        ASTPackageDeclaration pkg = (ASTPackageDeclaration)((ASTCompilationUnit)node.getFirstParentOfType(ASTCompilationUnit.class)).getFirstChildOfType(ASTPackageDeclaration.class);
        QualifiedName qname = new QualifiedName();
        qname.packages = pkg == null ? null : pkg.getPackageNameImage().split("\\.");
        qname.classes[0] = node.getImage();
        return qname;
    }

    public static QualifiedName makeClassOf(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    public static QualifiedName parseName(String name) {
        QualifiedName qname = new QualifiedName();
        Matcher matcher = FORMAT.matcher(name);
        if (!matcher.matches()) {
            return null;
        }
        qname.packages = ".".equals(matcher.group(1)) ? null : matcher.group(1).split("\\.");
        qname.classes = matcher.group(3).split("\\$");
        qname.operation = matcher.group(6) == null ? null : matcher.group(6).substring(1);
        return qname;
    }

    private static String getOperationName(String methodName, ASTFormalParameters params) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        int last = params.getParameterCount() - 1;
        for (int i = 0; i < last; ++i) {
            sb.append(((ASTType)params.jjtGetChild(i).getFirstDescendantOfType(ASTType.class)).getTypeImage());
            sb.append(", ");
        }
        if (last > -1) {
            sb.append(((ASTType)params.jjtGetChild(last).getFirstDescendantOfType(ASTType.class)).getTypeImage());
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean isClass() {
        return this.classes[0] != null && this.operation == null;
    }

    public boolean isOperation() {
        return this.operation != null;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public String[] getClasses() {
        return this.classes;
    }

    public String getOperation() {
        return this.operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        if (!Arrays.equals(this.packages, that.packages)) {
            return false;
        }
        if (!Arrays.equals(this.classes, that.classes)) {
            return false;
        }
        return this.operation != null ? this.operation.equals(that.operation) : that.operation == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.packages);
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        return result;
    }

    public String toString() {
        int i;
        int last;
        StringBuilder sb = new StringBuilder();
        if (this.packages != null) {
            last = this.packages.length - 1;
            for (i = 0; i < last; ++i) {
                sb.append(this.packages[i]);
                sb.append('.');
            }
            sb.append(this.packages[last]);
        }
        sb.append('.');
        last = this.classes.length - 1;
        for (i = 0; i < last; ++i) {
            sb.append(this.classes[i]);
            sb.append('$');
        }
        sb.append(this.classes[last]);
        if (this.operation != null) {
            sb.append('#');
            sb.append(this.operation);
        }
        return sb.toString();
    }
}

